float sum(vec3 v) { 
    return v.x+v.y+v.z; 
}

vec4 textureNoTileArray(sampler2DArray sampleTexture, sampler2D _noiseTexture, vec3 textureCoorindates, bool actuallyRun) {
    if (!actuallyRun) {
        return texture(sampleTexture, textureCoorindates);
    } else {
        float k = texture(_noiseTexture, 0.0005 * textureCoorindates.xy).x;
        
        vec2 duvdx = dFdx(textureCoorindates.xy);
        vec2 duvdy = dFdy(textureCoorindates.xy);
        
        float l = k*8.0;
        float f = fract(l);
        
        float ia = floor(l+0.5);
        float ib = floor(l);
        f = min(f, 1.0-f)*2.0;
        
        vec2 offa = sin(vec2(3.0,7.0)*ia); // can replace with any other hash
        vec2 offb = sin(vec2(3.0,7.0)*ib); // can replace with any other hash

        vec4 cola = textureGrad(sampleTexture, textureCoorindates + vec3(offa, 0), duvdx, duvdy);
        vec4 colb = textureGrad(sampleTexture, textureCoorindates + vec3(offb, 0), duvdx, duvdy);
        
        return mix(cola, colb, smoothstep(0.2,0.8,f-0.1*sum((cola-colb).xyz)));
    }
}