vec4 getNeighbour(sampler2DRect image, ivec2 ourCoords, ivec2 offset) {
	return texelFetch(image, ourCoords + offset);
}

int oppositeDirection(int direction) {
	if (direction == 0 || direction == 2) { 
		return 2 - direction; 
	} else { 
		return 4 - direction; 
	};
}

int perpendicularDirection(int direction) {
	if (direction == 0 || direction == 2) {
		return 1;
	} else {
		return 2;
	}
}

vec3 getNormalFromNeighbours(vec3 centre, vec3 top, vec3 right, vec3 bottom, vec3 left) {
	vec3 dir1 = top - centre;
	vec3 dir2 = right - centre;
	vec3 dir3 = bottom - centre;
	vec3 dir4 = left - centre;

	vec3 result = normalize(
		cross(dir1, dir2) + cross(dir2, dir3) + cross(dir3, dir4) + cross(dir4, dir1)
	);
	result.y = -result.y;
	return result;
}

/* Turn a value into a number between 0.f and 1.f with a middle range clampMin <= value >= clampMax where 
   the output is 1.f, and linearly tapering down to 0.f at absMin and absMax
   Used to define an overall and ideal range for a variable to be between
   E.g. if we have a tree that grows between 10 degrees and 30 degrees, but most optimally between 15 and 25 degrees, 
   and we want to calculate the growth at particular temperatures we could call
   range(10, 15, 27, 25, 30) = 0.6
   range(10, 15, 20, 25, 30) = 1.0
   range(10, 15, 25, 25, 30) = 1.0
   range(10, 15, 9,  25, 30) = 0.0
   range(10, 15, 11, 25, 30) = 0.2
*/
float range(float absMin, float clampMin, float value, float clampMax, float absMax) {
	if (value > clampMax) {
		return 1.f - clamp((value - clampMax) / (absMax - clampMax), 0.f, 1.f);
	}
	if (value < clampMin) {
		return clamp((value - absMin) / (clampMin - absMin), 0.f, 1.f);
	}
	return 1.f;
}