uniform vec2 colourSetPoints[4];
uniform vec2 alphaSetPoints[4];

float getWaterColourTextureCoordinate(float depth) {
	if (depth < colourSetPoints[0][0]) {
		return (1.f - ((colourSetPoints[0][0] - depth) / colourSetPoints[0][0])) * colourSetPoints[0][1];
	}
	if (depth < colourSetPoints[1][0]) {
		return colourSetPoints[0][1] + (1.f - ((colourSetPoints[1][0] - depth) /  (colourSetPoints[1][0] - colourSetPoints[0][0]))) * (colourSetPoints[1][1] - colourSetPoints[0][1]);
	}
	if (depth < colourSetPoints[2][0]) {
		return colourSetPoints[1][1] + (1.f - ((colourSetPoints[2][0] - depth) /  (colourSetPoints[2][0] - colourSetPoints[1][0]))) * (colourSetPoints[2][1] - colourSetPoints[1][1]);
	}
	return colourSetPoints[2][1] + (1.f - ((colourSetPoints[3][0] - depth) /  (colourSetPoints[3][0] - colourSetPoints[2][0]))) * (colourSetPoints[3][1] - colourSetPoints[2][1]);
}

float getWaterAlpha(float depth, float override) {
	if (depth < alphaSetPoints[0][0]) {
		return (1.f - ((alphaSetPoints[0][0] - depth) / alphaSetPoints[0][0])) * alphaSetPoints[0][1];
	}
	if (depth < alphaSetPoints[1][0]) {
		return mix(
			alphaSetPoints[0][1] + (1.f - ((alphaSetPoints[1][0] - depth) /  (alphaSetPoints[1][0] - alphaSetPoints[0][0]))) * (alphaSetPoints[1][1] - alphaSetPoints[0][1]),
			1.f,
			override * 0.5f
		);
	}
	if (depth < alphaSetPoints[2][0]) {
		return mix(
			alphaSetPoints[1][1] + (1.f - ((alphaSetPoints[2][0] - depth) /  (alphaSetPoints[2][0] - alphaSetPoints[1][0]))) * (alphaSetPoints[2][1] - alphaSetPoints[1][1]),
			1.f,
			override
		);
	}
	return mix(
		alphaSetPoints[2][1] + (1.f - ((alphaSetPoints[3][0] - depth) /  (alphaSetPoints[3][0] - alphaSetPoints[2][0]))) * (alphaSetPoints[3][1] - alphaSetPoints[2][1]),
		1.f, 
		override
	);
}