#version 330

uniform sampler2D background;
uniform sampler2D mask;
uniform float timestep;
uniform int highlight;

in vec2 mainTexCoord;
in vec2 maskTexCoord;

out vec4 _output;

void main() {
	vec4 maskValue = texture(mask, maskTexCoord);
	if (int(maskValue.b * 255) == highlight) {
		_output = texture(background, mainTexCoord) * (1 + (1 * maskValue.a * abs(0.5 - fract(timestep/ 1.25f))));
	} else {
		_output = texture(background, mainTexCoord);
	}
}