#version 150

uniform mat4 ciModelViewProjection;
uniform float maskTexCoordXStart;
uniform float maskTexCoordXSize;

in vec4 ciPosition;
in vec2 ciTexCoord0;

out highp vec2 mainTexCoord;
out highp vec2 maskTexCoord;

void main() {
	gl_Position = ciModelViewProjection * ciPosition;
	mainTexCoord = ciTexCoord0;
	maskTexCoord = vec2(maskTexCoordXStart + (ciTexCoord0.x * maskTexCoordXSize), ciTexCoord0.y);
}

