#version 430

uniform sampler2D mainTexture;
uniform sampler2D backgroundTexture;
uniform ivec2 CENTRE_POINT;
uniform float MIN_ANGLE;
uniform float MAX_ANGLE;
uniform float CENTRE_ANGLE;

in vec2 texCoord;
in vec4 colour;

out vec4 _output;

#include "common/constants.glsl"

void main() {
    vec2 direction = (gl_FragCoord.xy - vec2(0.5, 0.5)) - CENTRE_POINT;
    float angle = (M_PI / 2.0)  - atan(direction.y, direction.x);

    _output = texture(backgroundTexture, texCoord);
    if (angle > MIN_ANGLE && angle < MAX_ANGLE) {
        vec4 dialColour = texture(mainTexture, texCoord);
    	_output = mix(_output, dialColour, dialColour.a);
    }
}