#version 150

uniform sampler2D uTex0;
uniform bool picking;
uniform vec3 lightDirection;

in vec4	colour;
in vec3	normal;
in vec2	texCoord;
in float usingTexture;

out vec4 outputColour;

void main() {
	if (picking) {
		outputColour = colour;
		return;
	}

	vec3 _lightDirection = lightDirection;

	float diffuse = max(dot(normalize(-normal), _lightDirection), 0);
	vec3 textureColour = vec3(1.0, 1.0, 1.0);
	if (usingTexture > 0.5) {
		textureColour = texture(uTex0, vec2(texCoord.s, texCoord.t)).rgb;
	}
	outputColour = vec4(textureColour * colour.rgb * ((diffuse * 0.4) + 0.6), 1.0);
}