#version 150

in vec4	ciPosition;
in vec2	ciTexCoord0;
in vec3	ciNormal;
in vec4	ciColor;
in vec4 instanceMatrix1;
in vec4 instanceMatrix2;
in vec4 instanceMatrix3;
in vec4 instanceMatrix4;
in vec4 pickingColour;
in vec3 animationFrames;

out highp vec2 texCoord;
out lowp vec4 colour;
out highp vec3 normal;
out lowp float usingTexture;

uniform mat4 ciModelViewProjection;
uniform mat3 ciNormalMatrix;
uniform bool picking;

void main() {
	mat4 modelMatrix;
	mat3 modelMatrix3x3;
	modelMatrix3x3[0].rgb = instanceMatrix1.rgb;
	modelMatrix3x3[1].rgb = instanceMatrix2.rgb;
	modelMatrix3x3[2].rgb = instanceMatrix3.rgb;
	modelMatrix[0].rgba = instanceMatrix1;
	modelMatrix[1].rgba = instanceMatrix2;
	modelMatrix[2].rgba = instanceMatrix3;
	modelMatrix[3].rgba = instanceMatrix4;
	gl_Position	= (ciModelViewProjection * modelMatrix) * ciPosition;	
	texCoord = ciTexCoord0;
	normal = normalize(modelMatrix3x3 * ciNormal);

	colour = ciColor; 
	usingTexture = 1.0;

	// if (picking) {
	// 	usingTexture = 0.0;
	// 	colour = pickingColour;
	// }
}
