#version 330

uniform sampler2DRect texture1;
uniform uint attributeOffset;
uniform bool usingSubset;
uniform ivec2 subsetStart;
uniform ivec2 subsetEnd;

in vec2 texCoord;

out vec4 _output;

void main() {
	ivec2 _texCoord = ivec2(texCoord);
	if (usingSubset) {
		if (_texCoord.x >= subsetStart.x && _texCoord.x <= subsetEnd.x && _texCoord.y >= subsetStart.y && _texCoord.y <= subsetEnd.y) {
			_output = texture(texture1, texCoord);
		} else {
			_output = vec4(0);
		}
	} else {
		_output = texture(texture1, texCoord);
	}
}