#version 330

uniform sampler2DRect texture1;
uniform sampler2DRect texture2;
uniform bool usingSubset;
uniform ivec2 subsetStart;
uniform ivec2 subsetEnd;

in vec2 texCoord;

out vec4 output1;
out vec4 output2;

void main() {
	ivec2 _texCoord = ivec2(texCoord);
	if (usingSubset) {
		if (_texCoord.x >= subsetStart.x && _texCoord.x <= subsetEnd.x && _texCoord.y >= subsetStart.y && _texCoord.y <= subsetEnd.y) {
			output1 = texture(texture1, texCoord);
			output2 = texture(texture2, texCoord);
		} else {
			output1 = vec4(0);
			output2 = vec4(0);
		}
	} else {
		output1 = texture(texture1, texCoord);
		output2 = texture(texture2, texCoord);
	}
}