#version 330

uniform sampler2DRect texture1;
uniform sampler2DRect texture2;

in vec2 texCoord;

out vec4 _output1;
out vec4 _output2;

void main() {
	vec4 tex1_1 = texture(texture1, texCoord + vec2(0, 0));
	vec4 tex1_2 = texture(texture1, texCoord + vec2(0, 1));
	vec4 tex1_3 = texture(texture1, texCoord + vec2(1, 0));
	vec4 tex1_4 = texture(texture1, texCoord + vec2(1, 1));

	vec4 tex2_1 = texture(texture2, texCoord + vec2(0, 0));
	vec4 tex2_2 = texture(texture2, texCoord + vec2(0, 1));
	vec4 tex2_3 = texture(texture2, texCoord + vec2(1, 0));
	vec4 tex2_4 = texture(texture2, texCoord + vec2(1, 1));

	vec4 totals1 = tex1_1 + tex1_2 + tex1_3 + tex1_4;
	vec4 totals2 = tex2_1 + tex2_2 + tex2_3 + tex2_4;
	_output1 = totals1;
	_output2 = totals2;
}