#version 330

uniform sampler2DRect texture1;
uniform sampler2DRect texture2;
uniform sampler2DRect texture3;
uniform sampler2DRect texture4;

in vec2 texCoord;

out vec4 output1;
out vec4 output2;
out vec4 output3;
out vec4 output4;

void main() {
	vec4 tex1_1 = texture(texture1, texCoord + vec2(0, 0));
	vec4 tex1_2 = texture(texture1, texCoord + vec2(0, 1));
	vec4 tex1_3 = texture(texture1, texCoord + vec2(1, 0));
	vec4 tex1_4 = texture(texture1, texCoord + vec2(1, 1));

	vec4 tex2_1 = texture(texture2, texCoord + vec2(0, 0));
	vec4 tex2_2 = texture(texture2, texCoord + vec2(0, 1));
	vec4 tex2_3 = texture(texture2, texCoord + vec2(1, 0));
	vec4 tex2_4 = texture(texture2, texCoord + vec2(1, 1));

	vec4 tex3_1 = texture(texture3, texCoord + vec2(0, 0));
	vec4 tex3_2 = texture(texture3, texCoord + vec2(0, 1));
	vec4 tex3_3 = texture(texture3, texCoord + vec2(1, 0));
	vec4 tex3_4 = texture(texture3, texCoord + vec2(1, 1));

	vec4 tex4_1 = texture(texture4, texCoord + vec2(0, 0));
	vec4 tex4_2 = texture(texture4, texCoord + vec2(0, 1));
	vec4 tex4_3 = texture(texture4, texCoord + vec2(1, 0));
	vec4 tex4_4 = texture(texture4, texCoord + vec2(1, 1));

	output1 = tex1_1 + tex1_2 + tex1_3 + tex1_4;
	output2 = tex2_1 + tex2_2 + tex2_3 + tex2_4;
	output3 = tex3_1 + tex3_2 + tex3_3 + tex3_4;
	output4 = tex4_1 + tex4_2 + tex4_3 + tex4_4;
}