#version 430

#include "common/constants.glsl"
#include "common/data/biomes.glsl"
#include "common/octohedral.glsl"

uniform sampler2DArray coloursTexture;
uniform sampler2DArray normalsTexture;
uniform sampler2D atlasTexture;
uniform vec3 lightDirection;
uniform vec3 diffuseColour;
uniform vec3 ambientColour;
uniform float diffuseAmount;
uniform float specularAmount;
uniform float ambientAmount;
uniform mat4 ciViewMatrixInverse;
uniform mat4 ciModelViewProjection;
uniform bool DEBUG_BILLBOARDS;
uniform int INTERPOLATED_VIEWS;
uniform bool ambientOcclusionEnabled;
uniform float AMBIENT_OCCLUSION_AMOUNT;

in vec4 fColour;
in float fOpacity;
in float fDiffuse;
in float fAmbient;
in float fRotation;
in vec2 texCoord;
flat in int view;
flat in int type;
flat in float fScale;

out vec4 _output;

vec3 rotate(vec3 v, vec3 axis, float angle) {
    float cosTheta = cos(angle);
    float sinTheta = sin(angle);

    return (v * cosTheta) +
           (cross(axis, v) * sinTheta) +
           (axis * dot(axis, v) * (1.0 - cosTheta));
                   
}

void main() {
	vec4 projectedOutput = vec4(0);
	vec3 projectedNormal = vec3(0);
	float depth = 0.f;
	float opacity = 0.f;
	float ambientOcclusion = 1.f;

	vec3 texCoords = vec3(
		plantDefinitions[type].rotations[view].start + (plantDefinitions[type].rotations[view].size * texCoord), 
		plantDefinitions[type].rotations[view].layer
	);
	vec4 colour = texture(coloursTexture, texCoords);
	vec4 normal = texture(normalsTexture, texCoords);
	vec4 trunkColour = vec4(plantDefinitions[type].trunkColourRed, plantDefinitions[type].trunkColourGreen,
					  plantDefinitions[type].trunkColourBlue, 1.f);

	if (colour.a > 0.f || colour.x > 0.f) {
		if (fColour.a > 0.5f) {
			projectedOutput += (fColour * colour.x * colour.b);
			projectedOutput += (trunkColour * colour.a * (1.f - colour.b));
			projectedNormal += getNormalFromOctahedralCoordinates(normal.zw) * colour.b;
			projectedNormal += getNormalFromOctahedralCoordinates(normal.xy) * (1.f - colour.b);
		} else {
			projectedOutput = (trunkColour * colour.a);
			projectedNormal = getNormalFromOctahedralCoordinates(normal.xy);
		}
		if (ambientOcclusionEnabled) {
			ambientOcclusion -= ((1.f - colour[1]) * AMBIENT_OCCLUSION_AMOUNT);
		}
	}			

	if (projectedOutput.a == 0) {
		if (DEBUG_BILLBOARDS) {
			_output = vec4(1, 1, 1, 0.3);
		} else {
			discard;
		}
	} else {
		projectedNormal = normalize(rotate(-projectedNormal, vec3(0, 1, 0), -fRotation).xyz);
		float diffuse = max(dot(projectedNormal, lightDirection), 0);
		_output = vec4(
			(diffuseColour * projectedOutput.rgb * fDiffuse * diffuse * diffuseAmount * fOpacity) + 
			(ambientColour * projectedOutput.rgb * fAmbient * ambientAmount * fOpacity * ambientOcclusion),
			fOpacity * projectedOutput.a
		);
	}
}