#version 430

uniform vec3 lightDirection;
uniform vec3 eyePoint;
uniform vec3 diffuseColour;
uniform vec3 ambientColour;
uniform sampler2D biomePalette;
uniform sampler2D colourPalette;
uniform float diffuseAmount;
uniform float specularAmount;
uniform float ambientAmount;
uniform bool CALCUATE_DIFFUSE;

in float grassColour;
in vec2 texCoord;
in float lighting;
in vec3 normal;
in float diffuseLighting;
in float ambientLighting;

out vec4 _output;

void main() {
	vec3 textureColour;
	if (grassColour > 1.f) {
		textureColour = texture(colourPalette, texCoord).xyz;
	} else {
		textureColour = texture(biomePalette, texCoord).xyz;
	}
	
	float diffuse = 1.f;
	if (CALCUATE_DIFFUSE) {
		diffuse = max(dot(normalize(normal), lightDirection), 0);
	}
	float ambient = 1.f;

	_output = vec4(
		textureColour * diffuseColour * diffuse * diffuseLighting * diffuseAmount * lighting + 
		textureColour * ambientColour * ambient * ambientLighting * ambientAmount * lighting,
		1.f
	);
}