#version 430

#include "common/interpolations.glsl"

uniform mat4 ciModelMatrix;
uniform mat4 ciModelView;
uniform mat4 ciProjectionMatrix;
uniform mat4 ciModelViewProjection;
uniform mat3 ciNormalMatrix;
uniform mat4 ciViewMatrixInverse;
uniform float lightDirectionMix;
uniform bool shadowsEnabled;
uniform sampler2DRect lightingData;
uniform sampler2DRect shadowsData1; // shadows row 0
uniform sampler2DRect shadowsData2; // shadows row 1
uniform ivec2 localOffset;
uniform ivec3 worldOffset;
uniform ivec3 cameraOffset;
uniform sampler2DRect plants_data;
uniform ivec2 plants_offset;
uniform int plants_resolution;
uniform sampler2DRect biome_data;
uniform ivec2 biome_offset;
uniform int biome_resolution;
uniform ivec2 biome_size;
uniform int actualResolution;
uniform int stepCount;
uniform float NORMAL_ROUNDING;
uniform bool STEPPING;
uniform bool SCALE_SIZE;
uniform float transitionOutStart;
uniform float transitionOutLength;
uniform float LIGHTING_ADJUST;
uniform float EXISTS_NOISE_DIVISOR;
uniform float AMBIENT_BASE;
uniform float AMBIENT_EDGE_DISTANCE;
uniform float VIEW_SPACE_THICKENING;
uniform float COLOUR_VARIATION;
uniform float GLOBAL_OBJECT_SCALE;
uniform int BIOME_ATTRIBUTE;

// vertex buffer attributes, common across all instances
in vec3	ciPosition;
in vec2	ciTexCoord0;
in vec3	ciNormal;
// instance specific attributes
in vec2 position;
in vec2 yRotation;
in float heightVariation;

out float grassColour;
out vec2 texCoord;
out float lighting;
out vec3 normal;
out float ambientLighting;
out float diffuseLighting;

#include "common/resolutions.glsl"
#include "common/noise.glsl"

void main() {
	vec2 plantsDataPosition = convertCoordinates(position, actualResolution, plants_resolution, localOffset, plants_offset) + vec2(0.5, 0.5);
	vec4 plants = texture(plants_data, plantsDataPosition);

	vec2 dataPos = plants.zw;
	vec4 grass = texture(biome_data, dataPos);

	if (grass[BIOME_ATTRIBUTE] < 0.01f || dataPos.x < 0 || dataPos.y < 0 || dataPos.x >= (biome_size.x - 0.5f) || dataPos.y >= (biome_size.y - 0.5f)) {
		gl_Position = vec4(0.0, 0.0, 2.0, 1.0);
		return;
	}

	vec4 noise = texture(noiseTexture, (((localOffset + position) / 64.f) + (vec2(STEPPING ? stepCount : 0) / 128.f)) / noiseTextureSize);
	vec2 worldPosition = position * scale(actualResolution, 1);
	vec3 _position = vec3(worldPosition.x + cameraOffset.x, cameraOffset.y, worldPosition.y + cameraOffset.z);
	_position.y += plants[0];

	float ambientOcclusionAdjust = grass[BIOME_ATTRIBUTE];
	float _distance = distance(_position, ciViewMatrixInverse[3].xyz);
	float transitionRatio = 1.f - clamp((_distance - transitionOutStart) / transitionOutLength, 0.f, 1.f);
	if (grass[BIOME_ATTRIBUTE] < 1.f && SCALE_SIZE) {
		transitionRatio *= grass[BIOME_ATTRIBUTE];
	}

	// scale by frequency instead
	if (!SCALE_SIZE) {
		if (rand(position.xy) > grass[BIOME_ATTRIBUTE]) {
			gl_Position = vec4(0.0, 0.0, 2.0, 1.0);
			return;
		}
	}

	if (transitionRatio < 0.05f) {
		gl_Position = vec4(0.0, 0.0, 2.0, 1.0);
		return;
	}

	float absoluteWorldHeight = plants[0] + worldOffset.y;
	float illumination = texture(lightingData, dataPos)[0];
	ambientLighting = illumination;
	if (shadowsEnabled) {
		vec2 _shadows = texture(shadowsData1, dataPos).xy;
		vec2 vShadows1 = vec2(_shadows.x * 4096.f, _shadows.y * 32.f);
		_shadows = texture(shadowsData2, dataPos).xy;
		vec2 vShadows2 = vec2(_shadows.x * 4096.f, _shadows.y * 32.f);
		float _shadows1 = 1.f;
		if (absoluteWorldHeight < vShadows1[0]) {
			float shadowDist = vShadows1[1];
			float shadowBottom = vShadows1[0] - shadowDist;
			if (absoluteWorldHeight < shadowBottom) {
				_shadows1 = 0.f;
			} else {
				_shadows1 = mix(1.0, 0.f, (vShadows1[0] - absoluteWorldHeight) / shadowDist);
			}
		}
		float _shadows2 = 1.f;
		if (absoluteWorldHeight < vShadows2[0]) {
			float shadowDist = vShadows2[1];
			float shadowBottom = vShadows2[0] - shadowDist;
			if (absoluteWorldHeight < shadowBottom) {
				_shadows2 = 0.f;
			} else {
				_shadows2 = mix(1.0, 0.f, (vShadows2[0] - absoluteWorldHeight) / shadowDist);
			}
		}
		diffuseLighting = illumination * mix(_shadows1, _shadows2, lightDirectionMix);
	} else {
		diffuseLighting = illumination;
	}

	vec4 vertexPosition = vec4(ciPosition * GLOBAL_OBJECT_SCALE, 1.f);
	vertexPosition.y *= (1.f + heightVariation) * transitionRatio;// * max(grass[0], 0.01f);
	vertexPosition.xz *= transitionRatio;// * max(grass[0], 0.01f);

	float noiseAmount = 0.2f;
	float y = vertexPosition.y * 4.f;
	float xDeflect = (y * (-(noiseAmount / 2.f) + (noise[0] * noiseAmount))) * transitionRatio;
	float zDeflect = (y * (-(noiseAmount / 2.f) + (noise[1] * noiseAmount))) * transitionRatio;

	mat4 modelMatrix = mat4(
		yRotation[1], 0.f, yRotation[0], 0.f,
		0.f, 1.f, 0.f, 0.f,
		-yRotation[0], 0.f, yRotation[1], 0.f,
		_position.x + xDeflect, _position.y, _position.z + zDeflect, 1.f
	);
	vertexPosition.xz += vec2(xDeflect, zDeflect) * 0.3f;

	mat4 transformation = (ciModelView * modelMatrix);
	vertexPosition = transformation * vertexPosition;
	gl_Position = ciProjectionMatrix * vertexPosition;
	mat3 rotation = mat3(
		yRotation[1], 0.f, yRotation[0],
		0.f, 1.f, 0.f,
		-yRotation[0], 0.f, yRotation[1]
	);

	normal = rotation * ciNormal;
	lighting = mix(1.f, AMBIENT_BASE, (1.f - y) * ambientOcclusionAdjust);
	lighting = mix(lighting, 1.f, 1.f - transitionRatio);
	lighting = lighting * mix(LIGHTING_ADJUST, 1.f, 1.f - transitionRatio);

	if (ciTexCoord0.x == 0.f && ciTexCoord0.y == 0.f) {
		texCoord = vec2(min(grass[1] + (heightVariation * COLOUR_VARIATION), 14.5f / 16.f), (4.5f / 16.f));
		grassColour = 0.f;
	} else {
		texCoord = ciTexCoord0;
		grassColour = 2.f;
	}
	
}