#version 430

uniform mat4 ciModelViewProjection;
uniform mat4 ciViewMatrixInverse;
uniform float circumference;
uniform ivec2 localOffset;
uniform sampler2DRect data1; // plants row 0
uniform sampler2DRect data2; // shrubs row 0
uniform sampler2DRect data3; // shrubs row 1
uniform sampler2DRect lightingData;
uniform sampler2DRect shadowsData1; // shadows row 0
uniform sampler2DRect shadowsData2; // shadows row 1
uniform bool useDrawCoordinator;
uniform sampler2D drawCoordinatorTexture;
uniform ivec2 data1_offset;
uniform ivec2 data2_offset;
uniform ivec2 data2_size;
uniform int data1_resolution;
uniform int data2_resolution;
uniform int data4_resolution;
uniform int resolution;
uniform bool usingTransitionOpacity;
uniform float transitionInStart;
uniform float transitionInLength;
uniform float transitionOutStart;
uniform float transitionOutLength;
uniform bool shadowsEnabled;
uniform ivec2 drawCoordinatorOffset;

in vec4 ciPosition;
in vec4 ciColor;
in vec3 ciNormal;

out vec4 vColour;
out float vSkip;
out int vType;
out float vRotation;
out float vScale;
out float vOpacity;
out float vIllumination;
out vec2 vShadows1;
out vec2 vShadows2;

#include "common/constants.glsl"
#include "common/scale.glsl"
#include "common/data/biomes.glsl"

void main() {
	vec2 worldCoodinates = convertCoordinates(ciPosition.xz, resolution, 1, vec2(0, 0), vec2(0, 0));
	vec2 plantsPosition =  convertCoordinates(ciPosition.xz, resolution, data1_resolution, localOffset, data1_offset) + vec2(0.5, 0.5);
	vec2 shrubsPosition = convertCoordinates(ciPosition.xz, resolution, data2_resolution, localOffset, data2_offset) + vec2(0.5, 0.5);
	vec4 plants = texture(data1, plantsPosition);
	vec4 shrubs1 = texture(data2, shrubsPosition);
	vec4 shrubs2 = texture(data3, shrubsPosition);
	vec4 cameraPosition = vec4(
		worldCoodinates.x + cameraOffset.x, 
		shrubs1.x + cameraOffset.y, 
		worldCoodinates.y + cameraOffset.z, 1
	);
	vType = int(shrubs1.y);

	if (plantDefinitions[vType].renderBillboards != 1.f) {
		gl_Position = vec4(0.0, 0.0, 2.0, 1.0);
		return;
	}

	float alreadyDrawn = 0.f;
	if (useDrawCoordinator) {
		alreadyDrawn = texelFetch(drawCoordinatorTexture, localOffset - drawCoordinatorOffset + ivec2(ciPosition.xz), 0)[0];
	}
	vOpacity = 1.f - alreadyDrawn;
	int exists = int(shrubs1.x);
	if (vType == -1) {
		exists = 0;
	}

	if (usingTransitionOpacity) {
		float _distance = distance(cameraPosition, ciViewMatrixInverse[3]);
		float outOpacity = clamp((_distance - transitionOutStart) / transitionOutLength, 0.f, 1.f);
		float inOpacity = clamp(1.f - ((_distance - transitionInStart) / transitionInLength), 0.f, 1.f);
		vOpacity = vOpacity * min(inOpacity, outOpacity);
	}

	if (vOpacity == 0.f) {
		exists = 0;
	}

	if (exists == 0) {
		gl_Position = vec4(0.0, 0.0, 2.0, 1.0);
		vSkip = 1.0;
	} else {
		gl_Position = cameraPosition;
		vSkip = 0.0;
	}

	if (vSkip == 1.f) {
		vIllumination = 1.f;
	} else {
		vec2 dataPos = convertCoordinates(ciPosition.xz, resolution, data4_resolution, localOffset, vec2(0, 0)) + vec2(0.5, 0.5);
		if (shadowsEnabled) {
			vec2 _shadows = texture(shadowsData1, dataPos).xy;
			vShadows1 = vec2(_shadows.x * 4096.f, _shadows.y * 32.f);
			_shadows = texture(shadowsData2, dataPos).xy;
			vShadows2 = vec2(_shadows.x * 4096.f, _shadows.y * 32.f);
		}
		vIllumination = texture(lightingData, dataPos)[0];
	}

	vRotation = shrubs1.z;
	vScale = shrubs1.w;
	vColour = vec4(shrubs2.r, shrubs2.g, shrubs2.b, shrubs2.a);
}