#version 150

uniform mat4 ciModelViewProjection;
uniform mat4 ciViewMatrixInverse;
uniform float circumference;
uniform ivec2 offset;
uniform sampler2DRect data1; // plants row 0
uniform ivec2 data1_offset;
uniform int data1_resolution;
uniform int resolution;
uniform bool usingTransitionOpacity;
uniform float transitionInStart;
uniform float transitionInLength;
uniform float transitionOutStart;
uniform float transitionOutLength;

in vec4 ciPosition;
in vec4 ciColor;
in vec3 ciNormal;

out vec4 vColour;
out float vSkip;
out int vType;
out int vRotation;
out float vHeight;
out float vWidth;
out float vDepth;
out float vOpacity;
out float vIllumination;
out vec2 vShadows1;
out vec2 vShadows2;

float scale(int fromResolution, int toResolution) {
	int numerator = 1, denominator = 1;
	if (fromResolution > 0) {
		numerator *= fromResolution;
	} else {
		denominator *= -fromResolution;
	}
	if (toResolution > 0) {
		denominator *= toResolution;
	} else {
		numerator *= -toResolution;
	}
	return numerator / float(denominator);
}

vec2 convertCoordinates(vec2 coordinates, int inputResolution, int outputResolution, vec2 inputOffset, vec2 outputOffset) {
	float _scale = scale(inputResolution, outputResolution);
	return vec2((coordinates.x * _scale) + (inputOffset.x * _scale) - (outputOffset.x),
				(coordinates.y * _scale) + (inputOffset.y * _scale) - (outputOffset.y));
}

void main() {
	vec2 worldCoodinates = convertCoordinates(ciPosition.xz, resolution, 1, offset, vec2(0, 0));
	vec2 plantsPosition =  convertCoordinates(ciPosition.xz, resolution, data1_resolution, offset, data1_offset) + vec2(0.5, 0.5);

	vec4 plants = texture(data1, plantsPosition);
	vec4 position = vec4(worldCoodinates.x, 0, worldCoodinates.y, 1) + vec4(plants.z, plants.x, plants.w, 0);

	gl_Position = position;
	vSkip = 0.0;

	if (usingTransitionOpacity) {
		float _distance = distance(position, ciViewMatrixInverse[3]);
		float outOpacity = clamp((_distance - transitionOutStart) / transitionOutLength, 0.f, 1.f);
		float inOpacity = clamp(1.f - ((_distance - transitionInStart) / transitionInLength), 0.f, 1.f);
		vOpacity = min(inOpacity, outOpacity);
	} else {
		vOpacity = 1.f;
	}

	vType = 0;
	vRotation = 0;
	vHeight = 1.0;
	vWidth = vHeight / 2.0;
	vDepth = vHeight / 2.0;
	vColour = vec4(1);
	vIllumination = 1.f;
	vShadows1 = vec2(-16.f, 0.f);
	vShadows2 = vec2(-16.f, 0.f);
}