#version 150

layout(triangles) in;
layout(triangle_strip, max_vertices=3) out;

in float _active[];
in vec3 worldPosition[];

out vec3 normal;
out float _active2;
out vec3 _worldPosition;

void main() {	
	vec3 _normal = normalize(cross(worldPosition[1] - worldPosition[0], worldPosition[2] - worldPosition[0]));
	gl_Position = gl_in[0].gl_Position;
	normal = _normal;
	_active2 = _active[0];
	_worldPosition = worldPosition[0];
	EmitVertex();

	gl_Position = gl_in[1].gl_Position;
	normal = _normal;
	_active2 = _active[1];
	_worldPosition = worldPosition[1];
	EmitVertex();

	gl_Position = gl_in[2].gl_Position;
	normal = _normal;
	_active2 = _active[2];
	_worldPosition = worldPosition[2];
	EmitVertex();

	EndPrimitive();
}
