#version 150

uniform mat4 ciModelViewProjection;
uniform float circumference;
uniform ivec2 offset;
uniform sampler2DRect data1; // water row 0
uniform sampler2DRect data2;
uniform ivec2 data1_offset;
uniform int data1_resolution;
uniform int resolution;

in vec4 ciPosition;
in vec4 ciColor;
in vec3 ciNormal;

out float _active;
out vec3 worldPosition;

float scale(int fromResolution, int toResolution) {
	int numerator = 1, denominator = 1;
	if (fromResolution > 0) {
		numerator *= fromResolution;
	} else {
		denominator *= -fromResolution;
	}
	if (toResolution > 0) {
		denominator *= toResolution;
	} else {
		numerator *= -toResolution;
	}
	return numerator / float(denominator);
}

vec2 convertCoordinates(vec2 coordinates, int inputResolution, int outputResolution, vec2 inputOffset, vec2 outputOffset) {
	float _scale = scale(inputResolution, outputResolution);
	return vec2((coordinates.x * _scale) + (inputOffset.x * _scale) - (outputOffset.x),
				(coordinates.y * _scale) + (inputOffset.y * _scale) - (outputOffset.y));
}

void main() {
	// vec2 worldCoodinates = convertCoordinates(ciPosition.xz, resolution, 1, offset, vec2(0, 0));
	vec2 collisionPosition = convertCoordinates(ciPosition.xz, resolution, data1_resolution, offset, data1_offset) + vec2(0.5, 0.5);

	vec4 collisionPoint = texture(data1, collisionPosition);
	vec4 velocityPoint = texture(data1, collisionPosition);
	vec4 position = vec4(collisionPoint.x, collisionPoint.y, collisionPoint.z, 1);
	position = vec4(clamp(position.x, -20.01, 20.01), position.y, clamp(position.z, -20.01, 20.01), position.w);
	gl_Position = ciModelViewProjection * position;

	_active = collisionPoint.w + (velocityPoint.w > 0 ? 1 : 0);
	worldPosition = position.xyz;
}