#version 150

uniform mat4 ciModelViewProjection;
uniform ivec2 localOffset;
uniform ivec3 worldOffset;
uniform ivec3 cameraOffset;
uniform int resolution;
uniform float fResolution;
uniform int data1_resolution;
uniform ivec2 dataOffset;
uniform sampler2DRect data1; // water row 0
uniform sampler2DRect data2; // water offset
uniform sampler2DRect data3_rect_float; // data to display
uniform usampler2DRect data3_rect_unsigned; // data to display
uniform sampler2D data3_2d_float; // data to display
uniform usampler2D data3_2d_unsigned; // data to display
uniform int data3_resolution;
uniform ivec2 data3_offset;
uniform bool useWaterOffset;
uniform bool useTriangleSwitching;
uniform bool trianglesOpposite;
uniform int attributePosition;
uniform float maxValue;
uniform int dataType;
uniform int textureType;

in vec4 ciPosition;

out float value;

highp float rand(vec2 co) {

	int x = int(co.x);
	int y = int(co.y);
	highp float result = 0.f;

	for (int i = 0; i < 4; i++) {
		x += (x << 29);
		x ^= (x << 11);
		x ^= (y << 17);
		x ^= (x >> 19);
		x ^= (y >> 6);
		x ^= (x << 4);
	}

	result = x;
	
	return (x & 8191) / 8192.0;
}

float scale(int resolution1, int resolution2) {
	float ret = 1.f;
	if (resolution1 < 0) {
		ret = ret / -resolution1;
	} else {
		ret = ret * resolution1;
	}
	if (resolution2 < 0) {
		ret = ret * -resolution2;
	} else {
		ret = ret / resolution2;
	}
	return ret;
}

vec2 convertCoordinates(vec2 coordinates, int inputResolution, int outputResolution, vec2 inputOffset, vec2 outputOffset) {
	float _scale = scale(inputResolution, outputResolution);
	return vec2((coordinates.x * _scale) + (inputOffset.x * _scale) - (outputOffset.x),
				(coordinates.y * _scale) + (inputOffset.y * _scale) - (outputOffset.y));
}

vec4 getPosition(vec4 originalPosition) {
	return vec4((originalPosition.x * fResolution) + localOffset.x, 0.0, (originalPosition.z * fResolution) + localOffset.y, 1.0);
}

ivec2 getWaterPosition(vec2 position) {
	float _scale = scale(resolution, data1_resolution);
	return ivec2((position.x * _scale) + (localOffset.x * _scale), (position.y * _scale) + (localOffset.y * _scale));
}

vec2 getDataPosition(vec2 position) {
	float _scale = scale(resolution, data1_resolution);
	return vec2((position.x * _scale) + (localOffset.x * _scale), (position.y * _scale) + (localOffset.y * _scale));
}

void main() {
	vec4 vertexPosition = ciPosition;

	/* Read the water offset texture to figure out if we should flip the vertex ordering, so
		that the squares are divided into triangles the opposite way 
		We do this to avoid certain artifacts in the way the water is rendered, to make things smoother */
	if (useTriangleSwitching || trianglesOpposite) {
		int vertexNum = gl_VertexID % 6;
		if (vertexNum == 2 || vertexNum == 3) {
			if (vertexNum == 3) {
				vertexPosition -= vec4(1, 0, 0, 0);
			}
			if (vertexNum == 2) {
				vertexPosition -= vec4(0, 0, 1, 0);
			}
			vec2 waterPos = getWaterPosition(vertexPosition.xz) + vec2(0.5, 0.5);
			vec4 waterOffset = texture(data2, waterPos);
			bool offsetTextureTrianglesOpposite = (waterOffset.b == 1);
			if (trianglesOpposite) {
				if (useTriangleSwitching) {
					offsetTextureTrianglesOpposite = !offsetTextureTrianglesOpposite;
				} else {
					offsetTextureTrianglesOpposite = true;
				}
			}
			if (offsetTextureTrianglesOpposite) {
				if (vertexNum == 2) {
					vertexPosition += vec4(1, 0, 1, 0);
				}
			} else {
				if (vertexNum == 3) {
					vertexPosition += vec4(1, 0, 0, 0);
				}
				if (vertexNum == 2) {
					vertexPosition += vec4(0, 0, 1, 0);
				}
			}
		}	
	}

	/* Then figure out the actual vertex position */
	vec2 worldCoordinates = convertCoordinates(vertexPosition.xz, resolution, 1, vec2(0, 0), vec2(0, 0));
	vec4 _position = vec4(worldCoordinates.x, 0.0, worldCoordinates.y, 1.0);
	vec2 dataPos = getDataPosition(vertexPosition.xz) + vec2(0.5, 0.5);
	vec4 data = texture(data1, dataPos);
	vec4 waterOffset = texture(data2, dataPos);
	vec2 attributePos = convertCoordinates(vertexPosition.xz, resolution, data3_resolution, localOffset, data3_offset);

	_position.y = data.r;
	if (useWaterOffset) {
		_position += vec4(waterOffset.x, 0.0, waterOffset.y, 0.0) * data1_resolution;
	}
	_position += vec4(cameraOffset, 0);

	gl_Position = ciModelViewProjection * _position;

	switch(dataType) {
	case 0:
		vec4 floatAtttributeValue;
		if (textureType == 1) {
			floatAtttributeValue = texelFetch(data3_2d_float, ivec2(attributePos), 0);
		} else {
			floatAtttributeValue = texture(data3_rect_float, attributePos);
		}
		 
		value = floatAtttributeValue[attributePosition] / maxValue;
		break;
	case 1:
		uvec4 unsignedAtttributeValue;
		if (textureType == 1) {
			unsignedAtttributeValue = texelFetch(data3_2d_unsigned, ivec2(attributePos), 0);
		} else {
			unsignedAtttributeValue = texture(data3_rect_unsigned, attributePos);
		}

		uint container = unsignedAtttributeValue[attributePosition / 4];
		uint bitmask = uint(0xff) << ((attributePosition % 4) * 8);
		value = ((container & bitmask) / ((bitmask + uint(1))/ uint(256))) / 255.f;
		break;
	}
}