#version 430

uniform sampler2DRect biomes1;
uniform sampler2DRect biomes2;
uniform vec3 diffuseColour;
uniform vec3 ambientColour;
uniform float diffuseAmount;
uniform float ambientAmount;
uniform float diffuseReflectionAmbient;
uniform float diffuseReflectionDiffuse;
uniform float lightDirectionMix;
uniform vec3 lightDirection;
uniform bool shadowsEnabled;
uniform bool diffuseLightingEnabled;
uniform sampler2D mainTexture;
uniform float TEXTURE_SIZE;
uniform float TEXTURE_MIX;

#include "common/render/overlay.glsl"

in float discardVertex;
in float illumination;
in vec3 worldPosition;
in vec2 shadows1;
in vec2 shadows2;
in vec3 normal;

out vec4 _output;

vec4 textureSample() {
	vec4 dx = texture(mainTexture, vec2(worldPosition.zy / TEXTURE_SIZE));
	vec4 dy = texture(mainTexture, vec2(worldPosition.xz / TEXTURE_SIZE));
	vec4 dz = texture(mainTexture, vec2(worldPosition.xy / TEXTURE_SIZE));

	vec3 weights = abs(normal.xyz);
	weights = weights / (weights.x + weights.y + weights.z);

	return (dx * weights.x) + (dy * weights.y) + (dz * weights.z);
}

void main() {
	if (discardVertex > 0) {
		discard;
	}

	float shadows = 1.f;

	if (shadowsEnabled) {
		float _shadows1 = 1.f;
		if (worldPosition.y < shadows1[0]) {
			float shadowDist = shadows1[1];
			float shadowBottom = shadows1[0] - shadowDist;
			if (worldPosition.y < shadowBottom) {
				_shadows1 = 0.f;
			} else {
				_shadows1 = mix(1.0, 0.f, (shadows1[0] - worldPosition.y) / shadowDist);
			}
		}

		float _shadows2 = 1.f;
		if (worldPosition.y < shadows2[0]) {
			float shadowDist = shadows2[1];
			float shadowBottom = shadows2[0] - shadowDist;
			if (worldPosition.y < shadowBottom) {
				_shadows2 = 0.f;
			} else {
				_shadows2 = mix(1.0, 0.f, (shadows2[0] - worldPosition.y) / shadowDist);
			}
		}

		shadows = mix(_shadows1, _shadows2, lightDirectionMix);
	}

	float diffuseReflection = 1.f;
	if (diffuseLightingEnabled) {
		diffuseReflection = clamp(dot(normal, vec3(lightDirection.x, -lightDirection.y, lightDirection.z)), 0.f, 1.f);
	}
	float diffuseLighting = clamp((illumination * shadows * diffuseAmount * mix(1.f, diffuseReflection, diffuseReflectionDiffuse)), 0.f, 1.f);
	float ambientLighting = clamp(illumination * ambientAmount * mix(1.f, diffuseReflection, diffuseReflectionAmbient), 0.f, 1.f);
	float opacity = 1.f;
	vec3 textureColour = textureSample().rgb;
	vec3 colour = mix(vec3(1, 1, 1), textureColour, TEXTURE_MIX);
	_output = vec4(
		(
			(colour * diffuseLighting * diffuseColour) + 
			(colour * ambientLighting * ambientColour)
		), 
		opacity
	);

	_output = renderOverlay(_output, worldPosition, true);
}
