#version 430

uniform sampler2DArray mainTexture;
uniform mat4 ciModelViewProjection;
uniform mat4 ciViewMatrixInverse;
uniform mat4 shadowViewProjectionMatrix;
uniform float circumference;
uniform ivec2 localOffset;
uniform ivec3 worldOffset;
uniform ivec3 cameraOffset;
uniform sampler2DRect landHeight1; // landHeight row 0
uniform sampler2DRect data2; // water offset
uniform sampler2DRect water2; // water row 2
uniform sampler2DRect lightingData; // land shading
uniform sampler2DRect shadowsData1; // lighting row 0
uniform sampler2DRect shadowsData2; // lighting row 1
uniform int landHeight_resolution;
uniform int water_resolution;
uniform ivec2 landHeight_offset;
uniform ivec2 water_offset;
uniform ivec2 landHeight_size;
uniform ivec2 water_size;
uniform int textureSize;
uniform int resolution;
uniform bool useWaterOffset;
uniform bool useTriangleSwitching;
uniform bool trianglesOpposite;
uniform float transitionStart;
uniform float transitionLength;
uniform float RAINFALL_NORMALISED_TO_DISPLAY_MM_COVERSION;
uniform bool shadowsEnabled;

in vec4 ciPosition;

out vec3 worldPosition;
out vec2 texCoords;
out float discardFragment;
out float transition;
out float illumination;
out float groundwater;
out vec2 shadows1;
out vec2 shadows2;
out vec2 fDataPos;
out vec3 normal;
// out vec3 cameraSpacePosition;

#define M_PI 3.14159265358979323846

vec4 mod289(vec4 x) {
  return x - floor(x * (1.0 / 289.0)) * 289.0;
}

vec4 permute(vec4 x) {
  return mod289(((x*34.0)+1.0)*x);
}

vec4 taylorInvSqrt(vec4 r) {
  return 1.79284291400159 - 0.85373472095314 * r;
}

vec2 fade(vec2 t) {
  return t*t*t*(t*(t*6.0-15.0)+10.0);
}

vec3 hsv2rgb(vec3 c) {
	vec4 K = vec4(1.0, 2.0 / 3.0, 1.0 / 3.0, 3.0);
	vec3 p = abs(fract(c.xxx + K.xyz) * 6.0 - K.www);
	return c.z * mix(K.xxx, clamp(p - K.xxx, 0.0, 1.0), c.y);
}

vec4 getPlantsColour(vec4 data) {
	float hue = min(1.f, data.b * 1.5f);
	float plantsHueStart = 40, plantsHueEnd = 85;
	float plantHue = plantsHueStart + (hue * (plantsHueEnd - plantsHueStart));

	return vec4(hsv2rgb(vec3((plantHue) / 360.0, (99) / 255.0, (167 * data.a) / 255.0)), 1.0);
}

float scale(int resolution1, int resolution2) {
	float ret = 1.f;
	if (resolution1 < 0) {
		ret = ret / -resolution1;
	} else {
		ret = ret * resolution1;
	}
	if (resolution2 < 0) {
		ret = ret * -resolution2;
	} else {
		ret = ret / resolution2;
	}
	return ret;
}

vec2 convertCoordinates(vec2 coordinates, int inputResolution, int outputResolution, vec2 inputOffset, vec2 outputOffset) {
	float _scale = scale(inputResolution, outputResolution);
	return vec2((coordinates.x * _scale) + (inputOffset.x * _scale) - (outputOffset.x),
				(coordinates.y * _scale) + (inputOffset.y * _scale) - (outputOffset.y));
}

void main() {
	vec4 vertexPosition = ciPosition;

	/* Read the water offset texture to figure out if we should flip the vertex ordering, so
		that the squares are divided into triangles the opposite way 
		We do this to avoid certain artifacts in the way the water is rendered, to make things smoother */
	bool offsetTextureTrianglesOpposite = false;
	int vertexNum = gl_VertexID % 6;
	if (useTriangleSwitching || trianglesOpposite) {
		if (vertexNum == 2 || vertexNum == 3) {
			vec2 rootWaterVertex;
			if (vertexNum == 2) {
				rootWaterVertex = vertexPosition.xz - vec2(0, 1);
			}
			if (vertexNum == 3) {
				rootWaterVertex = vertexPosition.xz - vec2(1, 0);
			}
			ivec2 waterPos = ivec2(floor(convertCoordinates(rootWaterVertex, resolution, water_resolution, localOffset, water_offset)));
			vec4 waterOffset = texelFetch(data2, waterPos);
			offsetTextureTrianglesOpposite = (waterOffset.b == 1);
			if (trianglesOpposite) {
				if (useTriangleSwitching) {
					offsetTextureTrianglesOpposite = !offsetTextureTrianglesOpposite;
				} else {
					offsetTextureTrianglesOpposite = true;
				}
			}
			if (offsetTextureTrianglesOpposite) {
				if (vertexNum == 2) {
					vertexPosition += vec4(1, 0, 0, 0);
				}
				if (vertexNum == 3) {
					vertexPosition += vec4(-1, 0, 0, 0);
				}
			}
		}
	}

	fDataPos = convertCoordinates(vertexPosition.xz, resolution, water_resolution, localOffset, water_offset);
	vec2 dataPos = fDataPos + vec2(0.5, 0.5);
	vec2 landHeightPos = convertCoordinates(vertexPosition.xz, resolution, landHeight_resolution, localOffset, landHeight_offset) + vec2(0.5, 0.5);

	if (dataPos.x < 0 || dataPos.y < 0 || dataPos.x >= water_size.x || dataPos.y >= water_size.y) {
		discardFragment = 1;
	} else {
		discardFragment = 0;
	}

	vec4 landHeight = texture(landHeight1, landHeightPos);
	const float grassCutoff = (250.f / RAINFALL_NORMALISED_TO_DISPLAY_MM_COVERSION);
	groundwater = clamp((texture(water2, dataPos)[1] - grassCutoff) * 10.f, 0.f, 1.f);
	vec4 waterOffset = texture(data2, dataPos);
	vec4 illuminationData = texture(lightingData, dataPos);

	if (shadowsEnabled) {
		// shadowCoords = ((shadowViewProjectionMatrix * worldPosition).xy + vec2(1.f)) / 2.f;
		vec2 _shadows = texture(shadowsData1, dataPos).xy;
		vec2 additionalOffset = vec2(landHeight[3], 0.f);
		shadows1 = vec2(_shadows.x * 4096.f, _shadows.y * 32.f) - additionalOffset;
		_shadows = texture(shadowsData2, dataPos).xy;
		shadows2 = vec2(_shadows.x * 4096.f, _shadows.y * 32.f) - additionalOffset;
	}

	/* Dealing with chunk boundaries when chunks can be resolution=32 or higher */
#if 0
	bool xAxis = false, yAxis = false;

	if ((resolution == 16) && 
		(((xAxis = (int(dataPos.x) % 256 == 0)) && (int(dataPos.y) % 2 == 1)) ||
		 ((yAxis = (int(dataPos.y) % 256 == 0)) && (int(dataPos.x) % 2 == 1)))) {
		if (xAxis) {
			vec4 data0 = texture(data1, vec2(dataPos.x, dataPos.y - 1));
			vec4 data1 = texture(data1, vec2(dataPos.x, dataPos.y + 1));

			vec4 waterOffset0 = texture(data2, vec2(dataPos.x, dataPos.y - 1));
			vec4 waterOffset1 = texture(data2, vec2(dataPos.x, dataPos.y + 1));

			data = (data0 + data1) / 2.f;
			waterOffset = (waterOffset0 + waterOffset1) / 2.f;
		}
		if (yAxis) {
			vec4 data0 = texture(data1, vec2(dataPos.x - 1, dataPos.y));
			vec4 data1 = texture(data1, vec2(dataPos.x + 1, dataPos.y));

			vec4 waterOffset0 = texture(data2, vec2(dataPos.x - 1, dataPos.y));
			vec4 waterOffset1 = texture(data2, vec2(dataPos.x + 1, dataPos.y));

			data = (data0 + data1) / 2.f;
			waterOffset = (waterOffset0 + waterOffset1) / 2.f;	
		}
	} else {
		data = texture(data1, dataPos);
		waterOffset = texture(data2, dataPos);
	}
#endif
	
	vec2 worldCoordinates = convertCoordinates(vertexPosition.xz, resolution, 1, vec2(0), vec2(0));
	vec4 _position = vec4(worldCoordinates.x, landHeight[0], worldCoordinates.y, 1.0);
	if (useWaterOffset) {
		_position += vec4(waterOffset.x, 0.0, waterOffset.y, 0.0) * water_resolution;
	}

	worldPosition = worldOffset + _position.xyz;
	vec4 cameraPosition = vec4(cameraOffset, 0.f) + _position;
	// cameraSpacePosition = cameraPosition.xyz;
	gl_Position = ciModelViewProjection * cameraPosition;
	
	float _distance = distance(cameraPosition, ciViewMatrixInverse[3]);
	transition = clamp((_distance - (transitionStart - transitionLength)) / transitionLength, 0.f, 1.f);

	illumination = clamp(illuminationData[0], 0.f, 1.f);
	normal = vec3(landHeight[1], 1.f - (landHeight[1] + landHeight[2]), landHeight[2]);
	texCoords = (_position.xz / textureSize) + fract(worldOffset.xz / float(textureSize));
}
