#version 430

uniform sampler2DArray mainTexture;
uniform sampler2DArray grassTexture;
uniform sampler2DArray mudTexture;
uniform sampler2DArray igneousTexture;
uniform sampler2DArray sandTexture;
uniform sampler2DArray sandstoneTexture;
uniform sampler2D noiseTexture;
uniform sampler3D rockDepths;
uniform vec2 mousePosition;
uniform float mouseRadius;
uniform float lightAdjust;
uniform float transitionOpacity;
uniform bool renderCoverages;
uniform int data1_resolution;
uniform float lightDirectionMix;
uniform vec3 diffuseColour;
uniform vec3 ambientColour;
uniform float diffuseAmount;
uniform float ambientAmount;
uniform vec3 lightDirection;
uniform bool shadowsEnabled;
uniform int rockDepthsResolution;
uniform bool CALCULATE_DEPTHS;
uniform int textureSize;

in float discardFragment; // 1
in vec3 worldPosition;
in vec2 shadows1; // 2
in vec2 shadows2;
in float forestCoverage; // ?1
in float grassCoverage; // ?1
in float opacity; // 1
in float illumination; // ?1
in vec2 fDataPos;
flat in float normalY;

out vec4 _output;

vec4 grassColour = vec4(139 / 255.f, 146 / 255.f, 80 / 255.f, 1.f);
vec4 mudColour = vec4(85 / 255.f, 65 / 255.f, 46 / 255.f, 1.0);
vec4 igneousColour = vec4(59 / 255.f, 58 / 255.f, 57 / 255.f, 1.0);
vec4 sandstoneColour = vec4(162 / 255.f, 102 / 255.f, 60 / 255.f, 1.0);

float sum(vec3 v) { 
	return v.x+v.y+v.z; 
}

vec4 textureNoTileArray(sampler2DArray sampleTexture, sampler2D _noiseTexture, vec3 textureCoorindates) {
    float k = texture(_noiseTexture, 0.0005 * textureCoorindates.xy).x;
    
    vec2 duvdx = dFdx(textureCoorindates.xy);
    vec2 duvdy = dFdy(textureCoorindates.xy);
    
    float l = k*8.0;
    float f = fract(l);
    
    float ia = floor(l+0.5);
    float ib = floor(l);
    f = min(f, 1.0-f)*2.0;
    
    vec2 offa = sin(vec2(3.0,7.0)*ia); // can replace with any other hash
    vec2 offb = sin(vec2(3.0,7.0)*ib); // can replace with any other hash

    vec4 cola = textureGrad(sampleTexture, textureCoorindates + vec3(offa, 0), duvdx, duvdy);
    vec4 colb = textureGrad(sampleTexture, textureCoorindates + vec3(offb, 0), duvdx, duvdy);
    
    return mix(cola, colb, smoothstep(0.2,0.8,f-0.1*sum((cola-colb).xyz)));
}

float convertGrassCoverage(float value) {
	float diff = 1.f - value;
	diff = diff * diff * diff * diff;
	return 1.f - diff;
}

void main() {
	if (discardFragment > 0) {
		discard;
	}

	vec4 finalColour;
	float grassCoverage = convertGrassCoverage(grassCoverage);
	float forestCoverage = forestCoverage;
	vec2 texCoords = worldPosition.xz / textureSize;

	const float rockDepthsSize = 4096.f / rockDepthsResolution;
	float yPos = ((worldPosition.y / rockDepthsResolution) + 0.5f) / rockDepthsSize;
	// vec3 rockDepthsPosition = vec3(fDataPos.x + 0.5f, yPos, fDataPos.y + 0.5f);
	vec3 rockDepthsPosition = vec3(fDataPos.x, yPos, fDataPos.y);
	vec4 values = texture(rockDepths, rockDepthsPosition);

	float mudCoverage = clamp(values[0], 0.f, 1.f);
	float igneousCoverage = clamp(values[1], 0.f, 1.f);
	float sandstoneCoverage = clamp(values[2], 0.f, 1.f);

	if (normalY < 0.6f) {
		grassCoverage = grassCoverage * clamp((normalY - 0.5f) / 0.1f, 0.f, 1.f);
		forestCoverage = forestCoverage * clamp((normalY - 0.55f) / 0.05f, 0.f, 1.f);
	}

	if (renderCoverages) {
		float treeRenderSamples = 7;
		int sampleOffset = 0;

		vec4 groundColour = mix(igneousColour, sandstoneColour, sandstoneCoverage);
		groundColour = mix(groundColour, mudColour, mudCoverage);
		groundColour = mix(groundColour, grassColour, grassCoverage);
		// groundColour = mix(groundColour, igneousColour, clamp(igneousCoverage * 1.f, 0.f, 1.f));
		// groundColour = mix(groundColour, sandstoneColour, clamp(sandstoneCoverage * 1.f, 0.f, 1.f));

		float sandCoverage = clamp(2.f - worldPosition.y, 0.f, 1.f);
		if (sandCoverage > 0.f) {
			vec4 sandTex = texture(sandTexture, vec3(texCoords, 1));
			groundColour = mix(groundColour, sandTex, sandCoverage);
		}

		vec4 forestTextureLower = texture(mainTexture, vec3(texCoords.xy, floor(forestCoverage * treeRenderSamples) + sampleOffset));
		vec4 forestTextureUpper = texture(mainTexture, vec3(texCoords.xy, ceil(forestCoverage * treeRenderSamples) + sampleOffset));
		vec4 forestTextureColour = mix(forestTextureLower, forestTextureUpper, fract(forestCoverage * treeRenderSamples));

		finalColour = mix(groundColour, forestTextureColour, forestTextureColour.a);
	} else {
		vec3 variableCoverage = vec3(0.3) + texture(noiseTexture, texCoords / 256.f).xyz;
		variableCoverage = variableCoverage / (variableCoverage.x + variableCoverage.y + variableCoverage.z);

		vec4 mudTex = (texture(mudTexture, vec3(texCoords, 0)) * variableCoverage.x) + 
				  (texture(mudTexture, vec3(texCoords, 1)) * variableCoverage.y) + 
				  (texture(mudTexture, vec3(texCoords, 2)) * variableCoverage.z);

		vec4 grassTex = (texture(grassTexture, vec3(texCoords, 0)) * variableCoverage.x) + 
				  (texture(grassTexture, vec3(texCoords, 1)) * variableCoverage.y) + 
				  (texture(grassTexture, vec3(texCoords, 2)) * variableCoverage.z);
		grassTex = grassTex * 1.5;

		finalColour = mudTex;
		
		if (igneousCoverage != 0) {
			vec4 igneousTex = textureNoTileArray(igneousTexture, noiseTexture, vec3(texCoords, 0));
			finalColour = mix(finalColour, igneousTex, igneousCoverage);
		}

		if (sandstoneCoverage != 0) {
			vec4 sandstoneTex = textureNoTileArray(sandstoneTexture, noiseTexture, vec3(texCoords, 0));
			finalColour = mix(finalColour, sandstoneTex, sandstoneCoverage);
		}

		finalColour = mix(finalColour, grassTex, grassCoverage);

		float sandCoverage = clamp(2.f - worldPosition.y, 0.f, 1.f);
		if (sandCoverage > 0.f) {
			vec4 sandTex = texture(sandTexture, vec3(texCoords, 0));
			finalColour = mix(finalColour, sandTex, sandCoverage);
		}
	}

	// float comparisonValue = 0.0;
	// float shadowData = texture(shadowDepthTexture, vec3(shadowCoords, comparisonValue));

	float _shadows = 1;
	if (shadowsEnabled) {
		float _shadows1 = 1.f;
		if (worldPosition.y < shadows1[0]) {
			float shadowDist = shadows1[1];
			float shadowBottom = shadows1[0] - shadowDist;
			if (worldPosition.y < shadowBottom) {
				_shadows1 = 0.f;
			} else {
				_shadows1 = mix(1.0, 0.f, (shadows1[0] - worldPosition.y) / shadowDist);
			}
		}

		float _shadows2 = 1.f;
		if (worldPosition.y < shadows2[0]) {
			float shadowDist = shadows2[1];
			float shadowBottom = shadows2[0] - shadowDist;
			if (worldPosition.y < shadowBottom) {
				_shadows2 = 0.f;
			} else {
				_shadows2 = mix(1.0, 0.f, (shadows2[0] - worldPosition.y) / shadowDist);
			}
		}
		_shadows = mix(_shadows1, _shadows2, lightDirectionMix);
	}

	float diffuseLighting = clamp((illumination * _shadows * diffuseAmount), 0.f, 1.f);
	float ambientLighting = clamp(illumination * ambientAmount, 0.f, 1.f);
	float opacity = opacity;

	_output = vec4(
		lightAdjust * (
			(finalColour.xyz * diffuseLighting * diffuseColour) + 
			(finalColour.xyz * ambientLighting * ambientColour)
		), 
		opacity
	);

	/* Mouse area highlighting */
	float dist = distance(mousePosition, worldPosition.xz) / mouseRadius;
	if (dist > 0.95 && dist < 1) {
		_output = mix(_output, vec4(0, 0, 0, 1), 0.5);
	}
	if (dist <= 0.95) {
		_output = mix(_output, vec4(0, 0, 0, 1), 0.1);
	}
}
