#version 150

uniform sampler2DArray mainTexture;
uniform mat4 ciModelViewProjection;
uniform mat4 ciViewMatrixInverse;
uniform mat4 shadowViewProjectionMatrix;
uniform float circumference;
uniform ivec2 offset;
uniform sampler2DRect data1; // water row 0
uniform sampler2DRect data2; // water offset
uniform sampler2D data4; // coverages
uniform sampler2DRect lightingData; // land shading
uniform sampler2DRect shadowsData1; // lighting row 0
uniform sampler2DRect shadowsData2; // lighting row 1
uniform sampler3D normals; // lighting row 1
uniform int data1_resolution;
uniform int data2_resolution;
uniform int data3_resolution;
uniform int data4_resolution;
uniform ivec2 data1_offset;
uniform ivec2 data2_offset;
uniform ivec2 data3_offset;
uniform ivec2 data4_offset;
uniform ivec2 data1_size;
uniform ivec2 data2_size;
uniform ivec2 data3_size;
uniform ivec2 data4_size;
uniform int textureSize;
uniform int resolution;
uniform bool useWaterOffset;
uniform bool useTriangleSwitching;
uniform bool trianglesOpposite;
uniform bool usingTransitionOpacity;
uniform float transitionInStart;
uniform float transitionInLength;
uniform float transitionOutStart;
uniform float transitionOutLength;
uniform bool shadowsEnabled;

in vec4 ciPosition;

out vec3 worldPosition;
out float discardFragment;
out float forestCoverage;
out float grassCoverage;
out float opacity;
out float illumination;
out vec2 shadows1;
out vec2 shadows2;
out vec2 fDataPos;
flat out float normalY;

#define M_PI 3.14159265358979323846

vec4 mod289(vec4 x) {
  return x - floor(x * (1.0 / 289.0)) * 289.0;
}

vec4 permute(vec4 x) {
  return mod289(((x*34.0)+1.0)*x);
}

vec4 taylorInvSqrt(vec4 r) {
  return 1.79284291400159 - 0.85373472095314 * r;
}

vec2 fade(vec2 t) {
  return t*t*t*(t*(t*6.0-15.0)+10.0);
}

vec3 hsv2rgb(vec3 c) {
	vec4 K = vec4(1.0, 2.0 / 3.0, 1.0 / 3.0, 3.0);
	vec3 p = abs(fract(c.xxx + K.xyz) * 6.0 - K.www);
	return c.z * mix(K.xxx, clamp(p - K.xxx, 0.0, 1.0), c.y);
}

vec4 getPlantsColour(vec4 data) {
	float hue = min(1.f, data.b * 1.5f);
	float plantsHueStart = 40, plantsHueEnd = 85;
	float plantHue = plantsHueStart + (hue * (plantsHueEnd - plantsHueStart));

	return vec4(hsv2rgb(vec3((plantHue) / 360.0, (99) / 255.0, (167 * data.a) / 255.0)), 1.0);
}

float scale(int resolution1, int resolution2) {
	float ret = 1.f;
	if (resolution1 < 0) {
		ret = ret / -resolution1;
	} else {
		ret = ret * resolution1;
	}
	if (resolution2 < 0) {
		ret = ret * -resolution2;
	} else {
		ret = ret / resolution2;
	}
	return ret;
}

vec2 convertCoordinates(vec2 coordinates, int inputResolution, int outputResolution, vec2 inputOffset, vec2 outputOffset) {
	float _scale = scale(inputResolution, outputResolution);
	return vec2((coordinates.x * _scale) + (inputOffset.x * _scale) - (outputOffset.x),
				(coordinates.y * _scale) + (inputOffset.y * _scale) - (outputOffset.y));
}

void main() {
	vec4 vertexPosition = ciPosition;

	/* Then figure out the actual vertex position */
	vec2 worldCoordinates = convertCoordinates(vertexPosition.xz, resolution, 1, offset, vec2(0, 0));
	vec4 _position = vec4(worldCoordinates.x, 0.0, worldCoordinates.y, 1.0);
	ivec2 dataPos = ivec2(convertCoordinates(vertexPosition.xz, resolution, data1_resolution, offset, data1_offset));
	fDataPos = vec2((dataPos.x + 0.5f) / float(data1_size.x), (dataPos.y + 0.5f) / float(data1_size.y));
	vec4 data = texelFetch(data1, dataPos);
	vec4 waterOffset = texelFetch(data2, dataPos);
	vec4 illuminationData = texelFetch(lightingData, dataPos);

	if (dataPos.x < 0 || dataPos.y < 0 || dataPos.x >= data1_size.x || dataPos.y >= data1_size.y) {
		discardFragment = 1;
	} else {
		discardFragment = 0;
	}
	
	_position.y = data[0];
	if (useWaterOffset) {
		_position += vec4(waterOffset.x, 0.0, waterOffset.y, 0.0) * data1_resolution;
	}
	worldPosition = _position.xyz;

	if (shadowsEnabled) {
		// shadowCoords = ((shadowViewProjectionMatrix * worldPosition).xy + vec2(1.f)) / 2.f;
		vec2 _shadows = texelFetch(shadowsData1, dataPos).xy;
		shadows1 = vec2(_shadows.x * 4096.f, _shadows.y * 32.f);
		_shadows = texelFetch(shadowsData2, dataPos).xy;
		shadows2 = vec2(_shadows.x * 4096.f, _shadows.y * 32.f);
	}

	gl_Position = ciModelViewProjection * _position;

	if (usingTransitionOpacity) {
		float _distance = distance(_position, ciViewMatrixInverse[3]);
		float outOpacity = clamp((_distance - transitionOutStart) / transitionOutLength, 0.f, 1.f);
		float inOpacity = clamp(1.f - ((_distance - transitionInStart) / transitionInLength), 0.f, 1.f);
		opacity = min(inOpacity, outOpacity);
	} else {
		opacity = 1.f;
	}

	ivec2 coveragesPos = ivec2(floor(convertCoordinates(vertexPosition.xz, resolution, data4_resolution, offset, data4_offset)));
	forestCoverage = texelFetch(data4, coveragesPos, 0).x;
	grassCoverage = texelFetch(data4, coveragesPos, 0).z;
	illumination = clamp(illuminationData[0], 0.f, 1.f);
	normalY = texelFetch(normals, ivec3(dataPos.x, 0, dataPos.y - 1), 0).y;
}
