#version 430

uniform sampler2DRect biomes1;
uniform sampler2DRect biomes2;
uniform float DEPTH_CUTOFF;
uniform sampler2DArray displayTexture;
uniform sampler2D noiseTexture;
uniform float lightAdjust;
uniform vec3 diffuseColour;
uniform vec3 ambientColour;
uniform float diffuseAmount;
uniform float ambientAmount;
uniform float lightDirectionMix;
uniform float diffuseReflectionAmbient;
uniform float diffuseReflectionDiffuse;
uniform vec3 lightDirection;
uniform bool diffuseLightingEnabled;
uniform bool shadowsEnabled;
uniform bool USE_TEXTURE_TILING_ENHANCEMENTS;

#include "common/render/overlay.glsl"

in float discardVertex;
in float illumination;
in float temperatureBand;
in vec3 worldPosition;
in vec2 texCoords[4];
in vec2 shadows1;
in vec2 shadows2;
in vec3 normal;

out vec4 _output;

#include "common/textures.glsl"

void main() {
	if (discardVertex > 0) {
		discard;
	}

	vec4 textureColour = vec4(0);

	int floorTemp = clamp(int(floor(temperatureBand)), 0, 2);
	int ceilTemp = floorTemp + 1;
	
	vec4 textureValues[4];
	textureValues[0] = textureNoTileArray(displayTexture, noiseTexture, vec3(texCoords[0].xy, 0), USE_TEXTURE_TILING_ENHANCEMENTS);
	textureValues[1] = textureNoTileArray(displayTexture, noiseTexture, vec3(texCoords[1].xy, 1), USE_TEXTURE_TILING_ENHANCEMENTS);
	textureValues[2] = textureNoTileArray(displayTexture, noiseTexture, vec3(texCoords[2].xy, 2), USE_TEXTURE_TILING_ENHANCEMENTS);
	textureValues[3] = textureNoTileArray(displayTexture, noiseTexture, vec3(texCoords[3].xy, 3), USE_TEXTURE_TILING_ENHANCEMENTS);

	textureColour += mix(textureValues[floorTemp], textureValues[ceilTemp], fract(temperatureBand));

	float shadows = 1.f;

	if (shadowsEnabled) {
		float _shadows1 = 1.f;
		if (worldPosition.y < shadows1[0]) {
			float shadowDist = shadows1[1];
			float shadowBottom = shadows1[0] - shadowDist;
			if (worldPosition.y < shadowBottom) {
				_shadows1 = 0.f;
			} else {
				_shadows1 = mix(1.0, 0.f, (shadows1[0] - worldPosition.y) / shadowDist);
			}
		}

		float _shadows2 = 1.f;
		if (worldPosition.y < shadows2[0]) {
			float shadowDist = shadows2[1];
			float shadowBottom = shadows2[0] - shadowDist;
			if (worldPosition.y < shadowBottom) {
				_shadows2 = 0.f;
			} else {
				_shadows2 = mix(1.0, 0.f, (shadows2[0] - worldPosition.y) / shadowDist);
			}
		}

		shadows = mix(_shadows1, _shadows2, lightDirectionMix);
	}

	float diffuseReflection = 1.f;
	if (diffuseLightingEnabled) {
		diffuseReflection = clamp(dot(normal, vec3(lightDirection.x, -lightDirection.y, lightDirection.z)), 0.f, 1.f);
	}

	float diffuseLighting = clamp((illumination * shadows * diffuseAmount * mix(1.f, diffuseReflection, diffuseReflectionDiffuse)), 0.f, 1.f);
	float ambientLighting = clamp(illumination * ambientAmount * mix(1.f, diffuseReflection, diffuseReflectionAmbient), 0.f, 1.f);

	_output = vec4(
		(
			(textureColour.xyz * diffuseLighting * diffuseColour) + 
			(textureColour.xyz * ambientLighting * ambientColour)
		), 
		1.0
	);

	_output = renderOverlay(_output, worldPosition, true);
}
