#version 150

uniform vec3 diffuseColour;
uniform vec3 ambientColour;
uniform float diffuseAmount;
uniform float ambientAmount;
uniform float lightDirectionMix;
uniform bool shadowsEnabled;
uniform bool shouldOverrideColour;
uniform vec4 overrideColour;
uniform sampler2D waterGradient;

#include "common/water_display.glsl"

in vec3 worldPosition;
in vec2 shadows1;
in vec2 shadows2;
in float landHeight;
in float waterDepth;
in float ambient;

out vec4 _output;

void main() {
	vec3 colour = vec3(149 / 255.0, 126 / 255.0, 91 / 255.0);

	if (shouldOverrideColour) {
		_output = overrideColour;
	} else {
		_output = vec4(colour * ambientColour * ambientAmount * ambient, 1.0);
	}

	if (worldPosition.y > landHeight) {
		if (landHeight < 0) {
			// float shallowness = 1.0 - min(worldPosition.y / -1024.0, 0.5);
			// colour = vec3(0, 0.5 * shallowness, 1.0 * shallowness);
			float depth = max(waterDepth, -worldPosition.y);
			float waterTexCoord = getWaterColourTextureCoordinate(depth);
			vec3 colour = texture(waterGradient, vec2(waterTexCoord, 0.5f)).rgb;

			float diffuse = 1.f;
			float shadowYPos = 2.f;

			if (shadowsEnabled) {
				float _shadows1 = 1.f;
				if (shadowYPos < shadows1[0]) {
					float shadowDist = shadows1[1];
					float shadowBottom = shadows1[0] - shadowDist;
					if (shadowYPos< shadowBottom) {
						_shadows1 = 0.f;
					} else {
						_shadows1 = mix(1.0, 0.f, (shadows1[0] - shadowYPos) / shadowDist);
					}
				}

				float _shadows2 = 1.f;
				if (shadowYPos < shadows2[0]) {
					float shadowDist = shadows2[1];
					float shadowBottom = shadows2[0] - shadowDist;
					if (shadowYPos < shadowBottom) {
						_shadows2 = 0.f;
					} else {
						_shadows2 = mix(1.0, 0.f, (shadows2[0] - shadowYPos) / shadowDist);
					}
				}

				diffuse = mix(_shadows1, _shadows2, lightDirectionMix);
			}
			if (shouldOverrideColour) {
				_output = overrideColour;
			} else {
				_output = vec4((colour * diffuseColour * diffuseAmount * diffuse) + (colour * ambientColour * ambientAmount * ambient), 1.0);
			}
		}
	}
}
