#version 150

uniform mat4 ciModelViewProjection;
uniform sampler2DRect waterTexture;
uniform sampler2DRect shadowsData1;
uniform sampler2DRect shadowsData2;
uniform ivec3 cameraOffset;
uniform bool renderWater;

in vec4 ciPosition;
in vec2 ciTexCoord0;

out vec3 worldPosition;
out float landHeight;
out float ambient;
out vec2 shadows1;
out vec2 shadows2;
out float waterDepth;

void main() {
	vec4 water = texture(waterTexture, ciTexCoord0);
	
	vec2 _shadows = texture(shadowsData1, ciTexCoord0).xy;
	shadows1 = vec2(_shadows.x * 4096.f, _shadows.y * 32.f);
	_shadows = texture(shadowsData2, ciTexCoord0).xy;
	shadows2 = vec2(_shadows.x * 4096.f, _shadows.y * 32.f);

	worldPosition = vec3(ciPosition.xyz);

	if (ciPosition.y == 1) {
		if (renderWater) {
			worldPosition.y = max(water[2], 0);
		} else {
			worldPosition.y = water[0];
		}
	}
	gl_Position = ciModelViewProjection * vec4(worldPosition - cameraOffset, 1);
	if (renderWater) {
		landHeight = water[0];
		waterDepth = max(-landHeight, 0.f);
	} else {
		landHeight = water[2];
		waterDepth = 0.f;
	}

	ambient = 1.f;
}

