#version 150

uniform mat4 ciModelViewProjection;
uniform mat4 ciViewMatrixInverse;

layout(points) in;
layout(triangle_strip, max_vertices=40) out;

in vec4 digits1[];
in vec4 digits2[];
in int decimalPosition[];
in int negative[];

out highp vec2 texCoord;

void main() {
	mat4 axis = ciViewMatrixInverse;
	float size = 2.f;
	float digits[8];
	float numberDigits = 13.f;
	float spacing = 1.08f;
	vec4 pos = gl_in[0].gl_Position;
	digits[0] = digits1[0].x;
	digits[1] = digits1[0].y;
	digits[2] = digits1[0].z;
	digits[3] = digits1[0].w;
	digits[4] = digits2[0].x;
	digits[5] = digits2[0].y;
	digits[6] = digits2[0].z;
	digits[7] = digits2[0].w;

	/* Render each digit */
	for (int i=0; i<8; i++) {
		gl_Position = ciModelViewProjection * (gl_in[0].gl_Position + (axis[0] * (size * (i * spacing))) + (axis[1] * size * 0.5f));
		texCoord = vec2(digits[i] / numberDigits, 1);
		EmitVertex();

		gl_Position = ciModelViewProjection * (gl_in[0].gl_Position + (axis[0] * (size * (i * spacing))) - (axis[1] * size * 0.5f));
		texCoord = vec2(digits[i] / numberDigits, 0);
		EmitVertex();

		gl_Position = ciModelViewProjection * (gl_in[0].gl_Position + (axis[0] * (size * ((i * spacing) + 1))) + (axis[1] * size * 0.5f));
		texCoord = vec2((digits[i] + 1) / numberDigits, 1);
		EmitVertex();

		gl_Position = ciModelViewProjection * (gl_in[0].gl_Position + (axis[0] * (size * ((i * spacing) + 1))) - (axis[1] * size * 0.5f));
		texCoord = vec2((digits[i] + 1) / numberDigits, 0);
		EmitVertex();
		EndPrimitive();
	}

	/* Render the decimal point */
	gl_Position = ciModelViewProjection * (pos + (axis[0] * (size * ((decimalPosition[0] * spacing) + 0.6)) + (axis[1] * size * 0.5f)));
	texCoord = vec2(10 / numberDigits, 1);
	EmitVertex();

	gl_Position = ciModelViewProjection * (pos + (axis[0] * (size * ((decimalPosition[0] * spacing) + 0.6))) - (axis[1] * size * 0.5f));
	texCoord = vec2(10 / numberDigits, 0);
	EmitVertex();

	gl_Position = ciModelViewProjection * (pos + (axis[0] * (size * ((decimalPosition[0] * spacing) + 1.6))) + (axis[1] * size * 0.5f));
	texCoord = vec2(11 / numberDigits, 1);
	EmitVertex();

	gl_Position = ciModelViewProjection * (pos + (axis[0] * (size * ((decimalPosition[0] * spacing) + 1.6))) - (axis[1] * size * 0.5f));
	texCoord = vec2(11 / numberDigits, 0);
	EmitVertex();
	EndPrimitive();

	if (negative[0] == 1) {
		/* Render the negative sign */
		gl_Position = ciModelViewProjection * (pos + (axis[0] * (size * (0 * spacing)) + (axis[1] * size * 0.5f)));
		texCoord = vec2(12 / numberDigits, 1);
		EmitVertex();

		gl_Position = ciModelViewProjection * (pos + (axis[0] * (size * (0 * spacing)) - (axis[1] * size * 0.5f)));
		texCoord = vec2(12 / numberDigits, 0);
		EmitVertex();

		gl_Position = ciModelViewProjection * (pos + (axis[0] * (size * (-1 * spacing)) + (axis[1] * size * 0.5f)));
		texCoord = vec2(13 / numberDigits, 1);
		EmitVertex();

		gl_Position = ciModelViewProjection * (pos + (axis[0] * (size * (-1 * spacing)) - (axis[1] * size * 0.5f)));
		texCoord = vec2(13 / numberDigits, 0);
		EmitVertex();
		EndPrimitive();
	}
}
