#version 150

uniform mat4 ciModelViewProjection;
uniform ivec2 localOffset;
uniform ivec3 worldOffset;
uniform ivec3 cameraOffset;
uniform sampler2DRect data1; // water row 0
uniform sampler2DRect data2; // water offset
uniform sampler2DRect data3; // data to display
uniform int data1_resolution;
uniform int data2_resolution;
uniform int data3_resolution;
uniform ivec2 data1_offset;
uniform ivec2 data2_offset;
uniform ivec2 data3_offset;
uniform ivec2 data1_size;
uniform ivec2 data2_size;
uniform ivec2 data3_size;
uniform int resolution;
uniform bool useWaterOffset;
uniform bool useTriangleSwitching;
uniform bool trianglesOpposite;
uniform int dataAttribute;

in vec4 ciPosition;

out vec4 digits1;
out vec4 digits2;
out int decimalPosition;
out int negative;

float scale(int resolution1, int resolution2) {
	float ret = 1.f;
	if (resolution1 < 0) {
		ret = ret / -resolution1;
	} else {
		ret = ret * resolution1;
	}
	if (resolution2 < 0) {
		ret = ret * -resolution2;
	} else {
		ret = ret / resolution2;
	}
	return ret;
}

vec2 convertCoordinates(vec2 coordinates, int inputResolution, int outputResolution, vec2 inputOffset, vec2 outputOffset) {
	float _scale = scale(inputResolution, outputResolution);
	return vec2((coordinates.x * _scale) + (inputOffset.x * _scale) - (outputOffset.x),
				(coordinates.y * _scale) + (inputOffset.y * _scale) - (outputOffset.y));
}

void main() {
	vec4 vertexPosition = ciPosition;

	/* Read the water offset texture to figure out if we should flip the vertex ordering, so
		that the squares are divided into triangles the opposite way 
		We do this to avoid certain artifacts in the way the water is rendered, to make things smoother */
	if (false && (useTriangleSwitching || trianglesOpposite)) {
		int vertexNum = gl_VertexID % 6;
		if (vertexNum == 2 || vertexNum == 3) {
			if (vertexNum == 3) {
				vertexPosition -= vec4(1, 0, 0, 0);
			}
			if (vertexNum == 2) {
				vertexPosition -= vec4(0, 0, 1, 0);
			}
			vec2 waterPos = floor(convertCoordinates(vertexPosition.xz, resolution, data1_resolution, localOffset, data1_offset)) + vec2(0.5, 0.5);
			vec4 waterOffset = texture(data2, waterPos);
			bool offsetTextureTrianglesOpposite = (waterOffset.b == 1);
			if (trianglesOpposite) {
				if (useTriangleSwitching) {
					offsetTextureTrianglesOpposite = !offsetTextureTrianglesOpposite;
				} else {
					offsetTextureTrianglesOpposite = true;
				}
			}
			if (offsetTextureTrianglesOpposite) {
				if (vertexNum == 2) {
					vertexPosition += vec4(1, 0, 1, 0);
				}
			} else {
				if (vertexNum == 3) {
					vertexPosition += vec4(1, 0, 0, 0);
				}
				if (vertexNum == 2) {
					vertexPosition += vec4(0, 0, 1, 0);
				}
			}
		}
	}

	/* Then figure out the actual vertex position */
	vec2 worldCoordinates = convertCoordinates(vertexPosition.xz, resolution, 1, vec2(0, 0), vec2(0, 0));
	vec4 _position = vec4(worldCoordinates.x, 0.0, worldCoordinates.y, 1.0);
	vec2 waterPos = convertCoordinates(vertexPosition.xz, resolution, data1_resolution, localOffset, data1_offset) + vec2(0.5, 0.5);
	vec4 water = texture(data1, waterPos);
	vec4 waterOffset = texture(data2, waterPos);

	_position.y = (water[1] + water[2]);
	if (useWaterOffset && false) {
		_position += vec4(waterOffset.x, 0.0, waterOffset.y, 0.0) * data1_resolution;
	}
	gl_Position = _position + vec4(cameraOffset, 0);

	vec2 dataPos = convertCoordinates(vertexPosition.xz, resolution, data3_resolution, localOffset, data3_offset) + vec2(0.5, 0.5); 
	vec4 data = texture(data3, dataPos);
	float dataValue = min(999999.f, data[dataAttribute]);
	int digits[8];
	int digitAt = 0;
	bool recording = false;
	float columnValue = 100000;

	if (dataValue < 0) {
		dataValue = -dataValue;
		negative = 1;
	} else {
		negative = 0;
	}

	for (int i = 0; i<9; i++) {
		if (!recording) {
			if (dataValue >= columnValue || columnValue < 10) {
				recording = true;
			}
		}
		if (columnValue < 100) {
			decimalPosition = digitAt - 3;
		}
		if (recording && digitAt < 8) {
			digits[digitAt] = int(floor(dataValue / columnValue));
			if (digits[digitAt] != 0) {
				dataValue = mod(dataValue, (columnValue * digits[digitAt]));
			}
			digitAt++;
		}
		columnValue = columnValue / 10.0;
	}

	for (; digitAt < 8; digitAt++) {
		digits[digitAt] = 11;
	}

	digits1 = vec4(digits[0], digits[1], digits[2], digits[3]);
	digits2 = vec4(digits[4], digits[5], digits[6], digits[7]);
	
}
