#version 150

uniform mat4 ciModelViewProjection;
uniform float circumference;
uniform ivec2 offset;
uniform sampler2DRect data1; // water row 0
uniform ivec2 data1_offset;
uniform int data1_resolution;
uniform int resolution;

in vec4 ciPosition;
in vec4 ciColor;
in vec3 ciNormal;

// out vec4 colour;
// out float skip;
// out int type;
// out int rotation;
// out float plantHeight;

// #define M_PI 3.14159265358979323846

// highp float rand(vec2 co) {

// 	int x = int(co.x);
// 	int y = int(co.y);
// 	highp float result = 0.f;

// 	for (int i = 0; i < 4; i++) {
// 		x += (x << 29);
// 		x ^= (x << 11);
// 		x ^= (y << 17);
// 		x ^= (x >> 19);
// 		x ^= (y >> 6);
// 		x ^= (x << 4);
// 	}

// 	result = x;
	
// 	return (x & 8191) / 8192.0;
// }

// float randPos(vec2 co) {
// 	return (rand(co) - 0.5) * 4.0;
// }

float scale(int fromResolution, int toResolution) {
	int numerator = 1, denominator = 1;
	if (fromResolution > 0) {
		numerator *= fromResolution;
	} else {
		denominator *= -fromResolution;
	}
	if (toResolution > 0) {
		denominator *= toResolution;
	} else {
		numerator *= -toResolution;
	}
	return numerator / float(denominator);
}

vec2 convertCoordinates(vec2 coordinates, int inputResolution, int outputResolution, vec2 inputOffset, vec2 outputOffset) {
	float _scale = scale(inputResolution, outputResolution);
	return vec2((coordinates.x * _scale) + (inputOffset.x * _scale) - (outputOffset.x),
				(coordinates.y * _scale) + (inputOffset.y * _scale) - (outputOffset.y));
}


void main() {
	// vec2 worldCoodinates = convertCoordinates(ciPosition.xz, resolution, 1, offset, vec2(0, 0));
	vec2 collisionPosition = convertCoordinates(ciPosition.xz, resolution, data1_resolution, offset, data1_offset) + vec2(0.5, 0.5);

	vec4 collisionPoint = texture(data1, collisionPosition);
	vec4 position = vec4(collisionPoint.x, collisionPoint.y, collisionPoint.z, 1);
	gl_Position = ciModelViewProjection * position;
}