#version 150

uniform vec2 mousePosition;
uniform float mouseRadius;
uniform vec2 highlightStart;
uniform vec2 highlightEnd;

in float discardFragment;
in float illumination;
in vec4 worldPosition;

out vec4 _output;

void main() {
	if (discardFragment > 0) {
		discard;
	}

	vec2 _highlightStart = vec2(1024, 1024);
	vec2 _highlightEnd = vec2(2048, 2048);

	float dist = distance(mousePosition, worldPosition.xz) / mouseRadius;
	float mouseAmount = 0.f;
	if (dist > 0.95 && dist < 1) {
		mouseAmount = 0.5f;
	}
	if (dist <= 0.95) {
		mouseAmount = 0.1f;
	}

	if (worldPosition.x >= highlightStart.x && worldPosition.x <= highlightEnd.x && 
		worldPosition.z >= highlightStart.y && worldPosition.z <= highlightEnd.y) {
	// if (worldPosition.x >= _highlightStart.x && worldPosition.x <= _highlightEnd.x && 
	// 	worldPosition.z >= _highlightStart.y && worldPosition.z <= _highlightEnd.y) {
		_output = vec4(0.0 * illumination, 1.0 * illumination, 0.5 * illumination, 1.0);
	} else {
		_output = vec4(1.0 * illumination, 1.0 * illumination, 1.0 * illumination, 1.0);
	}

	_output = mix(_output, vec4(0, 0, 0, 1), mouseAmount);
}