#version 150

uniform vec2 mousePosition;
uniform float mouseRadius;
uniform sampler2DRect data5; // water row 3
uniform int displayedAttribute;

in float discardFragment;
in float illumination;
in vec4 worldPosition;
in vec4 customData1;
in vec4 customData2;
in vec4 customData3;

out vec4 _output;

void main() {
	if (discardFragment > 0) {
		discard;
	}

	float dist = distance(mousePosition, worldPosition.xz) / mouseRadius;
	float mouseIllumination = 1.f;
	if (dist > 0.95 && dist < 1) {
		mouseIllumination = 0.5f;
	}
	if (dist <= 0.95) {
		mouseIllumination = 0.9f;
	}

	float rainfallRatio = 0.f;
	if (displayedAttribute <= 3) {
		rainfallRatio = customData1[displayedAttribute];
	} else {
		if (displayedAttribute <= 7) {
			rainfallRatio = customData2[displayedAttribute - 4];
		} else {
			rainfallRatio = customData3[0];
		}

	} 

	_output = vec4(rainfallRatio, illumination, mouseIllumination, 1.0);
}
