#version 150

uniform vec2 mousePosition;
uniform float mouseRadius;

in float discardFragment;
in float illumination;
in vec4 worldPosition;

out vec4 _output;

void main() {
	if (discardFragment > 0) {
		discard;
	}

	float dist = distance(mousePosition, worldPosition.xz) / mouseRadius;
	float mouseAmount = 0.f;
	if (dist > 0.95 && dist < 1) {
		mouseAmount = 0.5f;
	}
	if (dist <= 0.95) {
		mouseAmount = 0.1f;
	}

	_output = vec4(worldPosition.y, illumination, mouseAmount, 1.0);
}