#version 150

uniform mat4 ciModelViewProjection;
uniform ivec2 localOffset;
uniform ivec3 worldOffset;
uniform ivec3 cameraOffset;
uniform int resolution;
uniform int data1_resolution;
uniform ivec2 dataOffset;
uniform sampler2DRect data1; // water row 0
uniform sampler2DRect data2; // water offset
uniform sampler2DRect lightingData; // rock properties
uniform sampler2DRect data3; // lava row 0
uniform sampler2DRect data4;
uniform sampler2DRect data5;
uniform sampler2DRect data6;
uniform ivec2 data1_size;
uniform bool useWaterOffset;
uniform bool useTriangleSwitching;
uniform bool trianglesOpposite;
uniform int numCustomRows;
uniform int heightMode;

in vec4 ciPosition;

out float discardFragment;
out float illumination;
out vec4 worldPosition;
out vec4 customData1;
out vec4 customData2;
out vec4 customData3;

highp float rand(vec2 co) {

	int x = int(co.x);
	int y = int(co.y);
	highp float result = 0.f;

	for (int i = 0; i < 4; i++) {
		x += (x << 29);
		x ^= (x << 11);
		x ^= (y << 17);
		x ^= (x >> 19);
		x ^= (y >> 6);
		x ^= (x << 4);
	}

	result = x;
	
	return (x & 8191) / 8192.0;
}

float scale(int resolution1, int resolution2) {
	float ret = 1.f;
	if (resolution1 < 0) {
		ret = ret / -resolution1;
	} else {
		ret = ret * resolution1;
	}
	if (resolution2 < 0) {
		ret = ret * -resolution2;
	} else {
		ret = ret / resolution2;
	}
	return ret;
}

vec2 convertCoordinates(vec2 coordinates, int inputResolution, int outputResolution, vec2 inputOffset, vec2 outputOffset) {
	float _scale = scale(inputResolution, outputResolution);
	return vec2((coordinates.x * _scale) + (inputOffset.x * _scale) - (outputOffset.x),
				(coordinates.y * _scale) + (inputOffset.y * _scale) - (outputOffset.y));
}

ivec2 getWaterPosition(vec2 position) {
	float _scale = scale(resolution, data1_resolution);
	return ivec2((position.x * _scale) + (localOffset.x * _scale), (position.y * _scale) + (localOffset.y * _scale));
}

vec2 getDataPosition(vec2 position) {
	float _scale = scale(resolution, data1_resolution);
	return vec2((position.x * _scale) + (localOffset.x * _scale), (position.y * _scale) + (localOffset.y * _scale));
}

void main() {
	vec4 vertexPosition = ciPosition;

	/* Read the water offset texture to figure out if we should flip the vertex ordering, so
		that the squares are divided into triangles the opposite way 
		We do this to avoid certain artifacts in the way the water is rendered, to make things smoother */
	if (useTriangleSwitching || trianglesOpposite) {
		int vertexNum = gl_VertexID % 6;
		if (vertexNum == 2 || vertexNum == 3) {
			if (vertexNum == 3) {
				vertexPosition -= vec4(1, 0, 0, 0);
			}
			if (vertexNum == 2) {
				vertexPosition -= vec4(0, 0, 1, 0);
			}
			vec2 waterPos = getWaterPosition(vertexPosition.xz) + vec2(0.5, 0.5);
			vec4 waterOffset = texture(data2, waterPos);
			bool offsetTextureTrianglesOpposite = (waterOffset.b == 1);
			if (trianglesOpposite) {
				if (useTriangleSwitching) {
					offsetTextureTrianglesOpposite = !offsetTextureTrianglesOpposite;
				} else {
					offsetTextureTrianglesOpposite = true;
				}
			}
			if (offsetTextureTrianglesOpposite) {
				if (vertexNum == 2) {
					vertexPosition += vec4(1, 0, 1, 0);
				}
			} else {
				if (vertexNum == 3) {
					vertexPosition += vec4(1, 0, 0, 0);
				}
				if (vertexNum == 2) {
					vertexPosition += vec4(0, 0, 1, 0);
				}
			}
		}	
	}

	vec2 dataPos = getDataPosition(vertexPosition.xz) + vec2(0.5, 0.5);
	vec4 data = texture(data1, dataPos);
	vec4 waterOffset = texture(data2, dataPos);
	vec4 lava = texture(data3, dataPos);

	if (numCustomRows > 0) {
		customData1 = texture(data4, dataPos);
	} else {
		customData1 = vec4(0);
	}
	if (numCustomRows > 1) {
		customData2 = texture(data5, dataPos);
	} else {
		customData2 = vec4(0);
	}
	if (numCustomRows > 2) {
		customData3 = texture(data6, dataPos);
	} else {
		customData3 = vec4(0);
	}

	if (dataPos.x < 0 || dataPos.y < 0 || dataPos.x >= data1_size.x || dataPos.y >= data1_size.y) {
		discardFragment = 1;
	} else {
		discardFragment = 0;
	}
	illumination = mix(1.0, texture(lightingData, dataPos)[0], 0.5);

	vec2 worldCoordinates = convertCoordinates(vertexPosition.xz, resolution, 1, vec2(0), vec2(0));
	vec4 _position;
	if (heightMode == 0) {
		_position = vec4(worldCoordinates.x, data[0] + lava[0], worldCoordinates.y, 1.0);
	}
	if (heightMode == 1) {
		_position = vec4(worldCoordinates.x, data[2], worldCoordinates.y, 1.0);
	}
	if (useWaterOffset) {
		_position += vec4(waterOffset.x, 0.0, waterOffset.y, 0.0) * data1_resolution;
	}
	worldPosition = vec4(worldOffset + _position.xyz, 1.f);
	vec4 cameraPosition = vec4(cameraOffset, 0.f) + _position;

	gl_Position = ciModelViewProjection * cameraPosition;

}