
#version 330

uniform sampler2D mainTexture;
uniform vec4 colour;
uniform float colourMix;
uniform vec3 lightDirection;
uniform vec3 eyePoint;
uniform vec3 diffuseColour;
uniform vec3 ambientColour;
uniform float diffuseAmount;
uniform float specularAmount;
uniform float ambientAmount;

in vec2 texCoord;
in vec3 normal;

out vec4 _output;

void main() {
	vec4 textureColour = texture(mainTexture, texCoord);
	float diffuse = max(dot(normalize(-normal), lightDirection), 0);

	_output = vec4(
		(textureColour.rgb * colour.rgb * ((diffuse * diffuseAmount) * diffuseColour)) + 
		(textureColour.rgb * ambientAmount * ambientColour), 
		textureColour.a
	);
	_output = mix(_output, colour, colourMix);
}