#version 150

uniform mat4 ciModelMatrix;
uniform mat4 ciModelViewProjection;
uniform mat4 ciViewProjection;
uniform mat3 ciNormalMatrix;
uniform sampler2DRect waterData;
uniform int waterResolution;
uniform sampler2D mainTexture;
uniform vec3 worldPosition;

in vec4 ciPosition;
in vec2 ciTexCoord0;
in vec3	ciNormal;

out vec2 texCoord;
out vec3 normal;

float scale(int resolution1, int resolution2) {
	float ret = 1.f;
	if (resolution1 < 0) {
		ret = ret / -resolution1;
	} else {
		ret = ret * resolution1;
	}
	if (resolution2 < 0) {
		ret = ret * -resolution2;
	} else {
		ret = ret / resolution2;
	}
	return ret;
}

vec2 convertCoordinates(vec2 coordinates, int inputResolution, int outputResolution, vec2 inputOffset, vec2 outputOffset) {
	float _scale = scale(inputResolution, outputResolution);
	return vec2((coordinates.x * _scale) + (inputOffset.x * _scale) - (outputOffset.x),
				(coordinates.y * _scale) + (inputOffset.y * _scale) - (outputOffset.y));
}

void main() {
	// vec4 _worldPosition = vec4(worldPosition.x, 0, worldPosition.y, 0);

	// ivec2 dataPos = ivec2(convertCoordinates(worldPosition.xz, 1, 16, vec2(0), vec2(0)));
	// vec4 data = texelFetch(waterData, dataPos);

	// _worldPosition.y = data.x;

	// gl_Position = ciModelMatrix * ciPosition;
	// gl_Position = gl_Position + vec4(worldPosition.xyz, 1);
	// gl_Position = ciViewProjection * gl_Position;
	gl_Position = ciModelViewProjection * ciPosition;

	texCoord = ciTexCoord0;
	normal = ciNormalMatrix * ciNormal;
}

