#version 150

uniform sampler2D displayTexture;
uniform sampler2DArray ambientOcclusionTexture;
uniform bool picking;
uniform vec3 lightDirection;
uniform vec3 eyePoint;
uniform vec3 diffuseColour;
uniform vec3 ambientColour;
uniform float diffuseAmount;
uniform float ambientAmount;
uniform bool ambientOcclusionEnabled;
uniform int ambientOcclusionLayer;
uniform float AMBIENT_OCCLUSION_AMOUNT;

in vec3	colour;
in vec3	normal;
in vec2	texCoord;
in vec2	aaTexCoord;
in float usingTexture;
in vec3 worldPosition;

out vec4 outputColour;

void main() {
	// if (picking) {
	// 	outputColour = colour;
	// 	return;
	// }

	float diffuse = max(dot(normalize(-normal), lightDirection), 0);
	vec3 viewDir = normalize(eyePoint - worldPosition);
	vec3 reflectDir = reflect(lightDirection, normal);  
	float spec = 1.f;

	vec4 textureColour = vec4(0.0, 1.0, 1.0, 1.0);
	if (usingTexture > 0.5) {
		textureColour = texture(displayTexture, texCoord);
	} else {
		textureColour = vec4(colour, 1.0);
	}
	if (textureColour.a == 0.f) {
		discard;
	}

	float ambientOcclusion = 1.f;
	if (ambientOcclusionEnabled) {
		ambientOcclusion = texture(ambientOcclusionTexture, vec3(aaTexCoord, ambientOcclusionLayer))[0];
		ambientOcclusion = mix(1.f, ambientOcclusion, AMBIENT_OCCLUSION_AMOUNT);
	}

	float diffuseLighting = diffuse * diffuseAmount;
	float ambientLighting = ambientAmount;

	outputColour = vec4(
		(
			(textureColour.xyz * diffuseLighting * diffuseColour) + 
			(textureColour.xyz * ambientLighting * ambientColour * ambientOcclusion)
		), 
		1.f
	);	
}