#version 150

uniform sampler2D displayTexture;
uniform sampler2DRect animations;
uniform vec3 diffuseColour;
uniform vec3 ambientColour;
uniform float diffuseAmount;
uniform float ambientAmount;
uniform float lightDirectionMix;
uniform bool shadowsEnabled;

in vec4	colour;
in vec2	texCoord;
in float usingTexture;
in float _highlight;
in float diffuse;
in float ambient;

out vec4 outputColour;

void main() {
	vec4 textureColour = vec4(1.0, 1.0, 1.0, 1.0);
	if (usingTexture > 0.5) {
		textureColour = texture(displayTexture, texCoord);
	}

	float diffuseLighting = diffuse * diffuseAmount;
	float ambientLighting = ambientAmount;

	outputColour = vec4(
		(
			(textureColour.xyz * diffuseLighting * diffuseColour) + 
			(textureColour.xyz * ambientLighting * ambientColour)
		), 
		1.f
	);

	// if (_highlight > 0.f) {
	// 	outputColour = mix(outputColour, vec4(1, 1, 1, 1), 0.35);
	// }
}