#version 150

uniform vec3 lightDirection;
uniform vec3 eyePoint;
uniform sampler2D displayTexture;
uniform sampler2DRect animations;
uniform int bonesCount;
uniform int animationTextureSize;
uniform mat4 ciModelViewProjection;
uniform mat3 ciNormalMatrix;
uniform sampler2DRect shadowsData1; // shadows row 0
uniform sampler2DRect shadowsData2; // shadows row 1
int shadowResolution;

// vertex buffer attributes
in vec4	ciPosition;
in vec2	ciTexCoord0;
in vec3	ciNormal;
in vec4	ciColor;
in vec4 ciBoneIndex;
in vec4 ciBoneWeight;
// instance attributes
in vec4 instanceMatrix1;
in vec4 instanceMatrix2;
in vec4 instanceMatrix3;
in vec4 instanceMatrix4;
in vec4 animationFrames1;
in vec4 animationFrames2;
in float highlight;

out vec2 texCoord;
out vec4 colour;
out float usingTexture;
out float _highlight;
out float diffuse;
out float ambient;

mat4 getBoneAnimation(int boneIndex, int frame1, int frame2, float interpolation) {
	int at1 = (frame1 * bonesCount * 4) + (boneIndex * 4);
	int at2 = (frame2 * bonesCount * 4) + (boneIndex * 4);
	mat4 ret;
	ret[0] = mix(
		texture(animations, vec2(at1 % animationTextureSize, at1 / animationTextureSize) + vec2(0.5, 0.5)),
		texture(animations, vec2(at2 % animationTextureSize, at2 / animationTextureSize) + vec2(0.5, 0.5)),
		interpolation
	);
	ret[1] = mix(
		texture(animations, vec2((at1 + 1) % animationTextureSize, (at1 + 1) / animationTextureSize) + vec2(0.5, 0.5)),
		texture(animations, vec2((at2 + 1) % animationTextureSize, (at2 + 1) / animationTextureSize) + vec2(0.5, 0.5)),
		interpolation
	);
	ret[2] = mix(
		texture(animations, vec2((at1 + 2) % animationTextureSize, (at1 + 2) / animationTextureSize) + vec2(0.5, 0.5)),
		texture(animations, vec2((at2 + 2) % animationTextureSize, (at2 + 2) / animationTextureSize) + vec2(0.5, 0.5)),
		interpolation
	);
	ret[3] = mix(
		texture(animations, vec2((at1 + 3) % animationTextureSize, (at1 + 3) / animationTextureSize) + vec2(0.5, 0.5)),
		texture(animations, vec2((at2 + 3) % animationTextureSize, (at2 + 3) / animationTextureSize) + vec2(0.5, 0.5)),
		interpolation
	);

	return ret;
}

void main() {
	mat4 modelMatrix;
	mat3 modelMatrix3x3;
	modelMatrix3x3[0].rgb = instanceMatrix1.rgb;
	modelMatrix3x3[1].rgb = instanceMatrix2.rgb;
	modelMatrix3x3[2].rgb = instanceMatrix3.rgb;
	modelMatrix[0].rgba = instanceMatrix1;
	modelMatrix[1].rgba = instanceMatrix2;
	modelMatrix[2].rgba = instanceMatrix3;
	modelMatrix[3].rgba = instanceMatrix4;

	mat4 skinMat = ciBoneWeight.x * (
		(getBoneAnimation(int(ciBoneIndex.x), int(animationFrames1.x), int(animationFrames1.y), animationFrames1.z) * animationFrames1.w) + 
		(getBoneAnimation(int(ciBoneIndex.x), int(animationFrames2.x), int(animationFrames2.y), animationFrames2.z) * animationFrames2.w)
	);

	skinMat += ciBoneWeight.y * (
		(getBoneAnimation(int(ciBoneIndex.y), int(animationFrames1.x), int(animationFrames1.y), animationFrames1.z) * animationFrames1.w) + 
		(getBoneAnimation(int(ciBoneIndex.y), int(animationFrames2.x), int(animationFrames2.y), animationFrames2.z) * animationFrames2.w)
	);
	skinMat += ciBoneWeight.z * (
		(getBoneAnimation(int(ciBoneIndex.z), int(animationFrames1.x), int(animationFrames1.y), animationFrames1.z) * animationFrames1.w) + 
		(getBoneAnimation(int(ciBoneIndex.z), int(animationFrames2.x), int(animationFrames2.y), animationFrames2.z) * animationFrames2.w)
	);
	skinMat += ciBoneWeight.w  * (
		(getBoneAnimation(int(ciBoneIndex.w), int(animationFrames1.x), int(animationFrames1.y), animationFrames1.z) * animationFrames1.w) + 
		(getBoneAnimation(int(ciBoneIndex.w), int(animationFrames2.x), int(animationFrames2.y), animationFrames2.z) * animationFrames2.w)
	);

	if (bonesCount == 0) {
		skinMat = mat4(1.0);
	}

	gl_Position = (ciModelViewProjection * modelMatrix) * (skinMat * ciPosition);
	vec3 normal = modelMatrix3x3 * (mat3(skinMat) * ciNormal);
	// vec4 position = modelMatrix * (skinMat * ciPosition);
	// vec2 dataPos = (position.xz / float(shadowResolution)) + vec2(0.5, 0.5);

	diffuse = max(dot(normalize(-normal), lightDirection), 0);
	ambient = 1.f;

	texCoord = ciTexCoord0;
	colour = ciColor; 
	usingTexture = 1.0;
	_highlight = highlight;
}
