#version 430

#include "common/noise.glsl"

uniform sampler2D displayTexture;
uniform sampler2DArray ambientOcclusionTexture;
uniform sampler2DRect animations;
uniform vec3 lightDirection;
uniform vec3 eyePoint;
uniform vec3 diffuseColour;
uniform vec3 ambientColour;
uniform float diffuseAmount;
uniform float specularAmount;
uniform float ambientAmount;
uniform float COLOUR_RANDOM_VARIATION;
uniform bool ambientOcclusionEnabled;
uniform int ambientOcclusionLayer;
uniform float AMBIENT_OCCLUSION_AMOUNT;

in vec4	colour;
in vec3	normal;
in vec2	texCoord;
in vec2	aaTexCoord;
in float diffuseLighting;
in float ambientLighting;
in float opacity;
in float colourVariation;
out vec4 outputColour;

void main() {
	// rudimentary dithering so we don't have to do actual transparency
	if (opacity < 0.99f && rand(vec2(aaTexCoord.x * 256.f, aaTexCoord.y * 256.f)) > opacity) {
		discard;
	}
	float diffuse = max(dot(normalize(-normal), lightDirection), 0);

	float ambientOcclusion = 1.f;
	if (ambientOcclusionEnabled && colour.a != 0.f) {
		ambientOcclusion = texture(ambientOcclusionTexture, vec3(aaTexCoord, ambientOcclusionLayer))[0];
		// with the dithering we see through models and see backfacing, inside or very occluded triangles that are highly ambiently occluded
		// that wouldn't normally be seen, so limit ambient occlusion in that case
		if (opacity < 0.99f) {
			ambientOcclusion = max(0.7f, ambientOcclusion);
		}
		ambientOcclusion = mix(1.f, ambientOcclusion, AMBIENT_OCCLUSION_AMOUNT);
	}

	vec4 textureColour = texture(displayTexture, texCoord);
	if (textureColour.a == 0.f) {
		discard;
	}
	vec4 _colour;

	if (texCoord.x == 0.f) {
		if (colour.a == 0.f) {
			discard;
		} else {
			_colour = colour;
		}
	} else {
		_colour = vec4(textureColour.xyz, 1.f);
	}

	float colourRandomAmountG = 1.f + (COLOUR_RANDOM_VARIATION * (colourVariation - 0.5f));
	_colour.g = _colour.g * colourRandomAmountG;

	outputColour = vec4(
		(diffuseColour * _colour.rgb * diffuse * diffuseAmount * diffuseLighting) + 
		(ambientColour * _colour.rgb * ambientAmount * ambientLighting * ambientOcclusion),
		_colour.a
	);
}