#version 430

layout (binding = 2, r8) uniform restrict image2DRect drawCoordinator0Write;

uniform sampler2D displayTexture;
uniform mat4 ciModelMatrix;
uniform mat4 ciModelViewProjection;
uniform mat3 ciNormalMatrix;
uniform mat4 ciViewMatrixInverse;
uniform float lightDirectionMix;
uniform bool shadowsEnabled;
uniform sampler2DRect lightingData;
uniform sampler2DRect shadowsData1; // shadows row 0
uniform sampler2DRect shadowsData2; // shadows row 1
uniform bool usingDrawCoordinator;
uniform float transitionInEnd;
uniform float transitionInStart;
uniform float transitionInHalfLength;
uniform ivec2 drawCoordinatorOffset;

#include "common/resolutions.glsl"
#include "common/noise.glsl"

// per-vertex attributes
in vec4	ciPosition;
in vec2	ciTexCoord0;
in vec2	ciTexCoord1;
in vec3	ciNormal;

// instance attributes
in vec4 instanceMatrix1;
in vec4 instanceMatrix2;
in vec4 instanceMatrix3;
in vec4 instanceMatrix4;
in vec4 pickingColour;
in vec4 animationFrames1;
in vec4 animationFrames2;
in vec4 customAttributes;
in ivec2 drawCoordinates;
in ivec3 worldOffset;

out vec2 texCoord;
out vec2 aaTexCoord;
out vec4 colour;
out vec3 normal;
out float ambientLighting;
out float diffuseLighting;
out float opacity;
out float colourVariation;

void main() {
	opacity = 1.f;
	float billboardOpacity = 0.f;
	if (usingDrawCoordinator) {
		vec3 centreWorld = vec3(instanceMatrix4.rgb);
		float _distance = distance(centreWorld, ciViewMatrixInverse[3].rgb);
		opacity = clamp((transitionInStart - _distance) / transitionInHalfLength, 0.f, 1.f);
		billboardOpacity = clamp((_distance - transitionInEnd) / transitionInHalfLength, 0.f, 1.f);
		if (gl_VertexID == 0) {
			imageStore(drawCoordinator0Write, drawCoordinates - drawCoordinatorOffset, vec4(1.f - billboardOpacity, 0, 0, 0));
		}
	}


	mat4 modelMatrix;
	mat3 modelMatrix3x3;
	modelMatrix3x3[0].rgb = instanceMatrix1.rgb;
	modelMatrix3x3[1].rgb = instanceMatrix2.rgb;
	modelMatrix3x3[2].rgb = instanceMatrix3.rgb;
	modelMatrix[0].rgba = instanceMatrix1;
	modelMatrix[1].rgba = instanceMatrix2;
	modelMatrix[2].rgba = instanceMatrix3;
	modelMatrix[3].rgba = instanceMatrix4;

	gl_Position = (ciModelViewProjection * modelMatrix) * ciPosition;
	normal = modelMatrix3x3 * ciNormal;
	colourVariation = noise(normal.xy * 12.f);

	texCoord = ciTexCoord0;
	aaTexCoord = ciTexCoord1;
	colour = customAttributes; 

	vec4 position = vec4(worldOffset, 0) + (modelMatrix * ciPosition);
	vec2 dataPos = convertCoordinates(position.xz, 1, 16, vec2(0, 0), vec2(0, 0)) + vec2(0.5, 0.5);
	float illumination = texture(lightingData, dataPos)[0];
	ambientLighting = illumination;
	if (shadowsEnabled) {
		vec2 _shadows = texture(shadowsData1, dataPos).xy;
		vec2 vShadows1 = vec2(_shadows.x * 4096.f, _shadows.y * 32.f);
		_shadows = texture(shadowsData2, dataPos).xy;
		vec2 vShadows2 = vec2(_shadows.x * 4096.f, _shadows.y * 32.f);

		float _shadows1 = 1.f;
		if (position.y < vShadows1[0]) {
			float shadowDist = vShadows1[1];
			float shadowBottom = vShadows1[0] - shadowDist;
			if (position.y < shadowBottom) {
				_shadows1 = 0.f;
			} else {
				_shadows1 = mix(1.0, 0.f, (vShadows1[0] - position.y) / shadowDist);
			}
		}

		float _shadows2 = 1.f;
		if (position.y < vShadows2[0]) {
			float shadowDist = vShadows2[1];
			float shadowBottom = vShadows2[0] - shadowDist;
			if (position.y < shadowBottom) {
				_shadows2 = 0.f;
			} else {
				_shadows2 = mix(1.0, 0.f, (vShadows2[0] - position.y) / shadowDist);
			}
		}

		diffuseLighting = illumination * mix(_shadows1, _shadows2, lightDirectionMix);
	} else {
		diffuseLighting = illumination;
	}
}