#version 150

uniform sampler2D displayTexture;
uniform sampler2D emissiveTexture;
uniform sampler2DRect animations;
uniform vec3 lightDirection;
uniform vec3 eyePoint;
uniform float diffuseAmount;
uniform float specularAmount;
uniform float ambientAmount;
uniform float secondsElapsed;

in vec4	colour;
in vec3	normal;
in vec2	texCoord;
in vec3 worldPosition;
flat in int type;
in float _highlight;

out vec4 outputColour;

void main() {
	float diffuse = max(dot(normalize(-normal), lightDirection), 0);
	vec3 viewDir = normalize(eyePoint - worldPosition);
	vec3 reflectDir = reflect(lightDirection, normal);  
	float spec = 1.f;

	vec4 textureColour = texture(displayTexture, texCoord);
	vec4 emissiveColour = texture(emissiveTexture, texCoord);

	outputColour = vec4(textureColour.rgb * colour.rgb * ((diffuse * diffuseAmount) + (spec * specularAmount) + ambientAmount), 1.0);

	float emissiveMix = 0.f;
	if (emissiveColour.r > 0.9) {
		emissiveColour = vec4(1.0, 1.0, 1.0, 1.0);
		if (type == 1) {
			emissiveColour = vec4(0.0, 1.0, 0.23, 1.0);
		}
		if (type == 2) {
			emissiveColour = vec4(0.0, 0.5, 1.0, 1.0);
		}
		if (type == 4) {
			emissiveColour = vec4(1.0, 0.3294, 0, 1.0);
		}
		
		emissiveMix = abs(fract(secondsElapsed / 4.f) - 0.5f) * 2.f;
	} else {
		emissiveMix = 0.f;
	}

	outputColour = mix(outputColour, emissiveColour, emissiveMix);

	if (_highlight > 0.f) {
		outputColour = mix(outputColour, vec4(1, 1, 1, 1), 0.15);
	}
}