#version 150

// vertex buffer attributes
in vec4	ciPosition;
in vec2	ciTexCoord0;
in vec3	ciNormal;
in vec4	ciColor;
// instance attributes
in vec4 instanceMatrix1;
in vec4 instanceMatrix2;
in vec4 instanceMatrix3;
in vec4 instanceMatrix4;
in vec4 pickingColour;
in vec4 animationFrames1;
in vec4 animationFrames2;
in vec4 customAttributes;
in float highlight;

uniform sampler2D displayTexture;
uniform mat4 ciModelViewProjection;
uniform mat3 ciNormalMatrix;

out highp vec2 texCoord;
out lowp vec4 colour;
out highp vec3 normal;
out vec3 worldPosition;
flat out int type;
out float _highlight;

void main() {
	mat4 modelMatrix;
	mat3 modelMatrix3x3;
	modelMatrix3x3[0].rgb = instanceMatrix1.rgb;
	modelMatrix3x3[1].rgb = instanceMatrix2.rgb;
	modelMatrix3x3[2].rgb = instanceMatrix3.rgb;
	modelMatrix[0].rgba = instanceMatrix1;
	modelMatrix[1].rgba = instanceMatrix2;
	modelMatrix[2].rgba = instanceMatrix3;
	modelMatrix[3].rgba = instanceMatrix4;

	gl_Position = (ciModelViewProjection * modelMatrix) * ciPosition;
	worldPosition = gl_Position.xyz;
	normal = modelMatrix3x3 * ciNormal;

	texCoord = ciTexCoord0;
	colour = ciColor; 
	type = int(customAttributes[0]);
	_highlight = highlight;
}
