#version 440

layout(local_size_x = 8, local_size_y = 8, local_size_z = 1) in;

layout (binding = 0) uniform sampler2DRect water0Read;

layout (binding = 0, rgba32f) uniform restrict image2DRect landHeight0Write;

uniform int water_resolution;
uniform int landHeight_resolution;
uniform ivec2 water_offset;
uniform ivec2 landHeight_offset;
uniform ivec2 landHeight_size;
uniform float RANDOM_HEIGHT;
uniform float RANDOM_DIVISOR;

#include "common/scale.glsl"
#include "common/spline.glsl"
#include "common/noise.glsl"

void main() {
	int subPointsEachDimension = water_resolution / landHeight_resolution;
	vec2 waterPos = (landHeight_offset / subPointsEachDimension) + vec2(gl_GlobalInvocationID.xy);
	float heights[16];
	float totalHeights[16];
	for (int z=0; z<4; z++) {
		for (int x=0; x<4; x++) {
			int at = (z * 4) + x;
			vec4 value = texture(water0Read, waterPos + vec2(x - 1, z - 1) + vec2(0.5, 0.5));
			heights[at] = value[0];
			totalHeights[at] = value[2];
		}
	}

	for (int z=0; z<4; z++) {
		for (int x=0; x<4; x++) {
			int at = (z * 4) + x;
			if (x == 0 && waterPos.x == 0) {
				heights[at] = heights[z * 4 + x + 1];
			}
			if (z == 0 && waterPos.y == 0) {
				heights[at] = heights[(z + 1) * 4 + x];
			}
		}
	}

	ivec2 landPos = ivec2(gl_GlobalInvocationID.xy) * subPointsEachDimension;

	for (int x = 0; x < subPointsEachDimension; x++) {
		for (int z = 0; z < subPointsEachDimension; z++) {
			vec2 pos = vec2(x, z) / subPointsEachDimension;

			float y[4] = float[4](
				catmullRomSpline(heights[0], heights[1], heights[2], heights[3], pos.x),
				catmullRomSpline(heights[4], heights[5], heights[6], heights[7], pos.x),
				catmullRomSpline(heights[8], heights[9], heights[10], heights[11], pos.x),
				catmullRomSpline(heights[12], heights[13], heights[14], heights[15], pos.x)
			);

			float height = catmullRomSpline(y[0], y[1], y[2], y[3], pos.y);

			float y_[4] = float[4](
				catmullRomSpline(totalHeights[0], totalHeights[1], totalHeights[2], totalHeights[3], pos.x),
				catmullRomSpline(totalHeights[4], totalHeights[5], totalHeights[6], totalHeights[7], pos.x),
				catmullRomSpline(totalHeights[8], totalHeights[9], totalHeights[10], totalHeights[11], pos.x),
				catmullRomSpline(totalHeights[12], totalHeights[13], totalHeights[14], totalHeights[15], pos.x)
			);

			// adding random height
			// height += rand((waterPos + pos) / RANDOM_DIVISOR) * RANDOM_HEIGHT;

			float x_[4] = float[4](
				catmullRomSpline(totalHeights[0], totalHeights[4], totalHeights[8], totalHeights[12], pos.y),
				catmullRomSpline(totalHeights[1], totalHeights[5], totalHeights[9], totalHeights[13], pos.y),
				catmullRomSpline(totalHeights[2], totalHeights[6], totalHeights[10], totalHeights[14], pos.y),
				catmullRomSpline(totalHeights[3], totalHeights[7], totalHeights[11], totalHeights[15], pos.y)
			);

			float normalZ = catmullRomSplineNormal(y_[0], y_[1], y_[2], y_[3], pos.y) / 16.f;
			float normalX = catmullRomSplineNormal(x_[0], x_[1], x_[2], x_[3], pos.x) / 16.f;

			vec3 normal = normalize(vec3(normalX, 1.f, normalZ));

			ivec2 landHeightPos = landPos + ivec2(x, z);
			if (landHeightPos.x >= 0 && landHeightPos.y >= 0 && landHeightPos.x < landHeight_size.x && landHeightPos.y < landHeight_size.y) {
				imageStore(landHeight0Write, landPos + ivec2(x, z), vec4(height, normal.x, normal.z, totalHeights[5] - height));
			}
		}
	}
}