// shader that calculates land normals from the output of land height- for when we have added randomness to land heights

#version 440

layout(local_size_x = 8, local_size_y = 8, local_size_z = 1) in;

layout (binding = 0) uniform sampler2DRect landHeight0Read;
layout (binding = 1) uniform sampler2DRect water0Read;

layout (binding = 0, rgba32f) uniform restrict image2DRect landHeight0Write;

uniform int landHeight_resolution;
uniform ivec2 landHeight_offset;
uniform ivec2 landHeight_size;
uniform int water_resolution;

void main() {
	ivec2 landPos = ivec2(gl_GlobalInvocationID.xy);

	vec4 here = texelFetch(landHeight0Read, landPos);
	float neighbourHeights[4];
	neighbourHeights[0] = texture(landHeight0Read, landPos + vec2(0.5, 0.5) + vec2(0, -1))[0];
	neighbourHeights[1] = texture(landHeight0Read, landPos + vec2(0.5, 0.5) + vec2(1, 0))[0];
	neighbourHeights[2] = texture(landHeight0Read, landPos + vec2(0.5, 0.5) + vec2(0, 1))[0];
	neighbourHeights[3] = texture(landHeight0Read, landPos + vec2(0.5, 0.5) + vec2(-1, 0))[0];

	if (landPos.x >= 0 && landPos.y >= 0 && landPos.x < landHeight_size.x && landPos.y < landHeight_size.y) {
		vec3 normal = normalize(vec3(neighbourHeights[1] - neighbourHeights[3], water_resolution * 2.f, neighbourHeights[2] - neighbourHeights[0]));
		imageStore(landHeight0Write, landPos, vec4(here[0], normal.x, normal.z, 0.f));
	}
}