#version 440

layout(local_size_x = 8, local_size_y = 8, local_size_z = 1) in;

layout (binding = 0) uniform sampler2DRect water0Read;

layout (binding = 0, rg16) uniform writeonly image2DRect shadows0Write;
layout (binding = 1, rg16) uniform writeonly image2DRect shadows1Write;

uniform int water_resolution;
uniform vec3 shadowLightDirection1;
uniform vec3 shadowLightDirection2;
uniform float shadowSpread;
uniform float minimumShadowSpread;
uniform int groupSize;

void main() {
	vec3 lightDirection = shadowLightDirection1;
	if (gl_WorkGroupID.x < groupSize) {
		uint pixelPosition = (gl_GlobalInvocationID.x * 8) + gl_GlobalInvocationID.y;

		ivec2 size = imageSize(shadows0Write);
		float shadowStart = 0.f;
		if (lightDirection.y > 0.f) {
			shadowStart = 4096.f;
		}
		float shadowTop = shadowStart;
		float shadowDistance = minimumShadowSpread;

		vec2 pos, increment;
		ivec2 subIncrement;
		int primaryLength, secondaryDimension;
		float lightFallAmount;

		if (abs(lightDirection.x) >= (abs(lightDirection.z))) {
			int xStart = 0, xIncrement = 1;
			if (lightDirection.x < 0) {
				xStart = size.x - 1, xIncrement = -1;
			}
			int zIncrement = 1;
			if (lightDirection.z < 0) {
				zIncrement = -1;
			}

			pos = ivec2(xStart, pixelPosition);
			subIncrement = ivec2(0, zIncrement);
			increment = vec2(xIncrement, lightDirection.z / max(0.01, abs(lightDirection.x)));
			primaryLength = size.x;
			secondaryDimension = 1;
			lightFallAmount = (-lightDirection.y / abs(lightDirection.x)) * water_resolution;
		} else {
			int zStart = 0, zIncrement = 1;
			if (lightDirection.z < 0) {
				zStart = size.y - 1, zIncrement = -1;
			}
			int xIncrement = 1;
			if (lightDirection.x < 0) {
				xIncrement = -1;
			}

			pos = ivec2(pixelPosition, zStart);
			subIncrement = ivec2(xIncrement, 0);
			increment = vec2(lightDirection.x / max(0.01, abs(lightDirection.z)), zIncrement);
			primaryLength = size.y;
			secondaryDimension = 0;
			lightFallAmount = (-lightDirection.y / abs(lightDirection.z)) * water_resolution;
		}

		if (pos.x >= size.x || pos.y >= size.y) {
			return;
		}

		for (int i = 0; i < primaryLength; i++) {
			ivec2 _pos = ivec2(pos);
			vec4 water0 = texelFetch(water0Read, ivec2(floor(pos))), water1 = texelFetch(water0Read, ivec2(ceil(pos)));
			float height = mix(water0[2], water1[2], fract(pos[secondaryDimension]));

			bool inLight = false;
			if (height > shadowTop - lightFallAmount) {
				shadowTop = water0[2] - 2.f;	
				shadowDistance = minimumShadowSpread;
				inLight = true;
			} else {
				shadowTop -= lightFallAmount;
				shadowDistance += shadowSpread;
			}

			imageStore(shadows0Write, _pos, vec4(max(0.f, shadowTop / 4096.f), shadowDistance / 32.f, 0.f, 0.f));

			if (inLight) {
				shadowTop = height - 2.f;
			}

			pos += increment;
			if (pos.x >= size.x) {
				pos.x -= size.x;
				shadowTop = shadowStart;
				shadowDistance = minimumShadowSpread;
			}
			if (pos.x < 0) {
				pos.x += size.x;
				shadowTop = shadowStart;
				shadowDistance = minimumShadowSpread;
			}
			if (pos.y >= size.y) {
				pos.y -= size.y;
				shadowTop = shadowStart;
				shadowDistance = minimumShadowSpread;
			}
			if (pos.y < 0) {
				pos.y += size.y;
				shadowTop = shadowStart;
				shadowDistance = minimumShadowSpread;
			}
		}
	}

	lightDirection = shadowLightDirection2;
	if (gl_WorkGroupID.x >= groupSize) {
		uint pixelPosition = ((gl_GlobalInvocationID.x * 8) + gl_GlobalInvocationID.y) - (groupSize * 64);

		ivec2 size = imageSize(shadows1Write);
		float shadowStart = 0.f;
		if (lightDirection.y > 0.f) {
			shadowStart = 4096.f;
		}
		float shadowTop = shadowStart;
		float shadowDistance = minimumShadowSpread;

		vec2 pos, increment;
		ivec2 subIncrement;
		int primaryLength, secondaryDimension;
		float lightFallAmount;

		if (abs(lightDirection.x) >= (abs(lightDirection.z))) {
			int xStart = 0, xIncrement = 1;
			if (lightDirection.x < 0) {
				xStart = size.x - 1, xIncrement = -1;
			}
			int zIncrement = 1;
			if (lightDirection.z < 0) {
				zIncrement = -1;
			}

			pos = ivec2(xStart, pixelPosition);
			subIncrement = ivec2(0, zIncrement);
			increment = vec2(xIncrement, lightDirection.z / max(0.01, abs(lightDirection.x)));
			primaryLength = size.x;
			secondaryDimension = 1;
			lightFallAmount = (-lightDirection.y / abs(lightDirection.x)) * water_resolution;
		} else {
			int zStart = 0, zIncrement = 1;
			if (lightDirection.z < 0) {
				zStart = size.y - 1, zIncrement = -1;
			}
			int xIncrement = 1;
			if (lightDirection.x < 0) {
				xIncrement = -1;
			}

			pos = ivec2(pixelPosition, zStart);
			subIncrement = ivec2(xIncrement, 0);
			increment = vec2(lightDirection.x / max(0.01, abs(lightDirection.z)), zIncrement);
			primaryLength = size.y;
			secondaryDimension = 0;
			lightFallAmount = (-lightDirection.y / abs(lightDirection.z)) * water_resolution;
		}

		if (pos.x >= size.x || pos.y >= size.y) {
			return;
		}

		for (int i = 0; i < primaryLength; i++) {
			ivec2 _pos = ivec2(pos);
			vec4 water0 = texelFetch(water0Read, ivec2(floor(pos))), water1 = texelFetch(water0Read, ivec2(ceil(pos)));
			float height = mix(water0[2], water1[2], fract(pos[secondaryDimension]));

			bool inLight = false;
			if (height > shadowTop - lightFallAmount) {
				shadowTop = water0[2] - 2.f;	
				shadowDistance = minimumShadowSpread;
				inLight = true;
			} else {
				shadowTop -= lightFallAmount;
				shadowDistance += shadowSpread;
			}

			imageStore(shadows1Write, _pos, vec4(max(0.f, shadowTop / 4096.f), shadowDistance / 32.f, 0.f, 0.f));

			if (inLight) {
				shadowTop = height - 2.f;
			}

			pos += increment;
			if (pos.x >= size.x) {
				pos.x -= size.x;
				shadowTop = shadowStart;
				shadowDistance = minimumShadowSpread;
			}
			if (pos.x < 0) {
				pos.x += size.x;
				shadowTop = shadowStart;
				shadowDistance = minimumShadowSpread;
			}
			if (pos.y >= size.y) {
				pos.y -= size.y;
				shadowTop = shadowStart;
				shadowDistance = minimumShadowSpread;
			}
			if (pos.y < 0) {
				pos.y += size.y;
				shadowTop = shadowStart;
				shadowDistance = minimumShadowSpread;
			}
		}
	}
}