// Fragment shader for the GPU water flow simulation pass that calculates temperature
#version 430

layout(local_size_x = 8, local_size_y = 8, local_size_z = 1) in;

layout (binding = 0) uniform sampler2DRect water0Read;

layout (binding = 0, rg8) uniform restrict image2DRect temperature0Write;

uniform int DAY_OF_YEAR;
uniform ivec2 water_size;

#include "common/temperature.glsl"
#include "common/temperature_mean.glsl"

void main() {
	ivec2 dataPos = ivec2(gl_GlobalInvocationID.xy);
	vec4 heights = texelFetch(water0Read, dataPos);

	float landHeight = max(0.f, heights[0]);
	float meanTemperatureHereCelsius = getMeanTemperature(landHeight, vec2(dataPos) / vec2(water_size), dataPos);
	float currentCelsius = meanTemperatureHereCelsius + getAddedTemperatureFromSeason(DAY_OF_YEAR);
	vec4 value = vec4(celsiusToNormalised(currentCelsius), celsiusToNormalised(meanTemperatureHereCelsius), 0.f, 0.f);
	imageStore(temperature0Write, dataPos, value);
}