#version 430

layout(local_size_x = 1, local_size_y = 1, local_size_z = 1) in;

layout (binding = 0) uniform sampler2DRect layer1Row1Read;
layout (binding = 1) uniform sampler2DRect layer2Row0Read;

layout (binding = 0, rgba32f) uniform restrict image2DRect layer1Row1Write;
layout (binding = 1, rgba32f) uniform restrict image2DRect layer2Row0Write;

void main() {
	ivec2 dataPos = ivec2(gl_GlobalInvocationID.xy);

	vec4 layer1Row1Data = texture(layer1Row1Read, dataPos + vec2(0.5, 0.5));
	vec4 layer2Row0Data = texture(layer2Row0Read, dataPos + vec2(0.5, 0.5));

	imageStore(layer1Row1Write, dataPos, layer1Row1Data + vec4(1));
	imageStore(layer2Row0Write, dataPos, layer2Row0Data + vec4(1));
}