#version 430 core

uniform ivec2 iceActivation_size;

layout (local_size_x = 1, local_size_y = 1, local_size_z = 1) in;

layout (binding = 0) uniform usampler2DRect sentinals0Read;

layout (binding = 0, rg8) uniform restrict image2DRect iceActivation0Write;
layout (binding = 1, r32ui) uniform restrict uimage2DRect sentinals0Write;

void main() {
    uvec4 existingValues = texelFetch(sentinals0Read, ivec2(0, 0));
    imageStore(sentinals0Write, ivec2(0, 0), uvec4(existingValues[0] / 2));
    for (int x=0; x<iceActivation_size.x; x++) {
        for (int y=0; y<iceActivation_size.y; y++) {
            imageStore(iceActivation0Write, ivec2(x, y), vec4(0.f));
        }
    }
}