struct BorealForestData {
	uint coverage;
	uint growthTimer;
	uint targetCoverage;
	uint currentYearMinimumCoverage;
};

BorealForestData unpackBorealForestData(inout uint value) {
	return BorealForestData(value >> 24, (value & 0x00ff0000) >> 16, (value & 0x0000ff00) >> 8, (value & 0x000000ff));
}

uint packBorealForestData(inout BorealForestData value) {
	return (value.coverage << 24) | (value.growthTimer << 16) | (value.targetCoverage << 8) | (value.currentYearMinimumCoverage);
}

vec4 updateBorealForest(inout EnvironmentInfo info, inout float targetCoverage) {
	BorealForestData data = unpackBorealForestData(info.additionalData[1][2]);
	if (dayProgressed) {
		float groundwaterFactor = range(500.f, 750.f, info.groundwaterMM, 9999.f, 9999.f);
		float minimumRainfallFactor = range(250, 500.f, info.rainfallMM, 9999.f, 9999.f);
		float averageTemperatureFactor = range(-99.f, -99.f, info.temperature.meanCelsius, 3.f, 7.f);
		float innundationFactor = range(0, 0, info.inundationData.daysInnundatedLastYear, 15, 20);
		float currentCoverage = groundwaterFactor * minimumRainfallFactor * averageTemperatureFactor * info.normalFactor * innundationFactor;
		bool remove = false;
		if (info.standardExclusions) {
			currentCoverage = 0.f;
			remove = true;
		}
		uint coverageNow = clamp(uint(currentCoverage * 255u), 0u, 255u);
		#include mixin "operations/plants/biomes/tree_growth_mixin.glsl"
	}
	info.additionalData[1][2] = packBorealForestData(data);
	float amount = data.coverage / 255.f;
	targetCoverage = data.targetCoverage / 255.f;
	float leafColour = 0.f, underlayColour = 0.6f;
	if (info.snowCoverage > 0.5f) {
		leafColour = 1.f;
		underlayColour = 1.f;
	}
	return vec4(1.f / 255.f, amount, leafColour, underlayColour);
}